#include "stdafx.h"
#include "perser_json.h"
#include "cJSON.h"
#include "debug_strust.h"

int json_perser_video_cap(char *param, jy_video_ability_param_list_t *p_src)
{
	if (NULL == param)
	{
		return PARAM_ERROR;
	}
	cJSON *p_json_param = cJSON_Parse(param);
	if (p_json_param == NULL)
	{
		return JSON_PARAM_ERROR;
	}
	memset(p_src, 0, sizeof(jy_video_ability_param_list_t));
	cJSON* p_json_video_cap_list  = cJSON_GetObjectItemEx(p_json_param, "video_cap_list", cJSON_Array);
	if (NULL == p_json_video_cap_list)
	{
		return JSON_NODE_ERROR;
	}
	int nVideoCapSize = cJSON_GetArraySize(p_json_video_cap_list);
	for (int i = 0; i < nVideoCapSize; ++i)
	{
		cJSON *p_json_video_cap = cJSON_GetArrayItem(p_json_video_cap_list, i);
		if (NULL == p_json_video_cap)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_json_channel_id = cJSON_GetObjectItemEx(p_json_video_cap, "channel_id", cJSON_Number);
		if (NULL != p_json_channel_id)
		{
			p_src->video_param[i].channel_id = p_json_channel_id->valueint;
		}
		cJSON* p_json_base_stream_list  = cJSON_GetObjectItemEx(p_json_video_cap, "base_stream_list", cJSON_Array);
		if (NULL == p_json_base_stream_list)
		{
			return JSON_NODE_ERROR;
		}
		int nBaseStreamSize = cJSON_GetArraySize(p_json_base_stream_list);
		for (int j = 0; j < nBaseStreamSize; ++j)
		{
			cJSON *p_json_base_stream = cJSON_GetArrayItem(p_json_base_stream_list, j);
			if (NULL == p_json_base_stream)
			{
				return JSON_ARRAY_ERROR;
			}
			cJSON* p_json_stream_id = cJSON_GetObjectItemEx(p_json_base_stream, "stream_id", cJSON_Number);
			if (NULL != p_json_stream_id)
			{
				p_src->video_param[i].base_stream_list[j].stream_id = p_json_stream_id->valueint;
			}
			cJSON* p_json_enc_param_list = cJSON_GetObjectItemEx(p_json_base_stream, "encoder_param", cJSON_Array);
			if (NULL == p_json_enc_param_list)
			{
				return JSON_NODE_ERROR;
			}
			int nEncParamSize = cJSON_GetArraySize(p_json_enc_param_list);
			for (int k = 0; k < nEncParamSize; ++k)
			{
				cJSON *p_json_enc_param = cJSON_GetArrayItem(p_json_enc_param_list, k);
				if (NULL == p_json_enc_param)
				{
					return JSON_ARRAY_ERROR;
				}
				cJSON* p_json_en_type = cJSON_GetObjectItemEx(p_json_enc_param, "en_type", cJSON_Number);
				if (NULL != p_json_en_type)
				{
					p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].video_enc_type = p_json_en_type->valueint;
				}
				cJSON* p_json_en_name = cJSON_GetObjectItemEx(p_json_enc_param, "en_name", cJSON_String);
				if (NULL != p_json_en_name)
				{
					strcpy(p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].enc_type_name, p_json_en_name->valuestring);
				}
				cJSON* p_json_enc_level_list = cJSON_GetObjectItemEx(p_json_enc_param, "encode_level_list", cJSON_Array);
				if (NULL == p_json_enc_level_list)
				{
					return JSON_NODE_ERROR;
				}
				int nEnvLevelSize = cJSON_GetArraySize(p_json_enc_level_list);
				for(int m = 0; m < nEnvLevelSize; ++m)
				{
					cJSON *p_json_enc_level = cJSON_GetArrayItem(p_json_enc_level_list, m);
					if (NULL == p_json_enc_level)
					{
						return JSON_ARRAY_ERROR;
					}
					cJSON* p_json_en_level = cJSON_GetObjectItemEx(p_json_enc_level, "encoder_level", cJSON_Number);
					if (NULL != p_json_en_level)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_list[m].encoder_level = p_json_en_level->valueint;
					}
					++p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_num;
				}
				cJSON* p_json_base_cap_list = cJSON_GetObjectItemEx(p_json_enc_param, "base_cap", cJSON_Array);
				if (NULL == p_json_base_cap_list)
				{
					return JSON_NODE_ERROR;
				}
				int nBaseCapSize = cJSON_GetArraySize(p_json_base_cap_list);
				for(int n = 0; n < nBaseCapSize; ++n)
				{
					cJSON *p_json_base_cap = cJSON_GetArrayItem(p_json_base_cap_list, n);
					if (NULL == p_json_base_cap)
					{
						return JSON_ARRAY_ERROR;
					}
					cJSON* p_json_size_name = cJSON_GetObjectItemEx(p_json_base_cap, "size", cJSON_String);
					if (NULL != p_json_size_name)
					{
						strcpy(p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].size_name, p_json_size_name->valuestring);
					}
					cJSON* p_json_width = cJSON_GetObjectItemEx(p_json_base_cap, "width", cJSON_Number);
					if (NULL != p_json_width)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].width = p_json_width->valueint;
					}
					cJSON* p_json_height = cJSON_GetObjectItemEx(p_json_base_cap, "height", cJSON_Number);
					if (NULL != p_json_height)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].height = p_json_height->valueint;
					}
					cJSON* p_json_max_fps = cJSON_GetObjectItemEx(p_json_base_cap, "max_fps", cJSON_Number);
					if (NULL != p_json_max_fps)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].max_fps = p_json_max_fps->valueint;
					}
					cJSON* p_json_min_fps = cJSON_GetObjectItemEx(p_json_base_cap, "min_fps", cJSON_Number);
					if (NULL != p_json_min_fps)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].min_fps = p_json_min_fps->valueint;
					}
					cJSON* p_json_max_bps = cJSON_GetObjectItemEx(p_json_base_cap, "max_bps", cJSON_Number);
					if (NULL != p_json_max_bps)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].max_bps = p_json_max_bps->valueint;
					}
					cJSON* p_json_min_bps = cJSON_GetObjectItemEx(p_json_base_cap, "min_bps", cJSON_Number);
					if (NULL != p_json_min_bps)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].min_bps = p_json_min_bps->valueint;
					}
					cJSON* p_json_max_qul = cJSON_GetObjectItemEx(p_json_base_cap, "max_qul", cJSON_Number);
					if (NULL != p_json_max_qul)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].max_qul = p_json_max_qul->valueint;
					}
					cJSON* p_json_min_qul = cJSON_GetObjectItemEx(p_json_base_cap, "min_qul", cJSON_Number);
					if (NULL != p_json_min_qul)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].min_qul = p_json_min_qul->valueint;
					}
					cJSON* p_json_max_inval = cJSON_GetObjectItemEx(p_json_base_cap, "max_inval", cJSON_Number);
					if (NULL != p_json_max_inval)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].max_inval = p_json_max_inval->valueint;
					}
					cJSON* p_json_min_inval = cJSON_GetObjectItemEx(p_json_base_cap, "min_inval", cJSON_Number);
					if (NULL != p_json_min_inval)
					{
						p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[n].min_inval = p_json_min_inval->valueint;
					}
					++p_src->video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_num;
				}
				++p_src->video_param[i].base_stream_list[j].video_enc_param_num;
			}
			++p_src->video_param[i].base_stream_num;
		}
		++p_src->param_num;
	}
	cJSON_Delete(p_json_param);
	return 0;
}

int json_perser_av_stream(char *param, jy_get_av_stream_res_t *p_src)
{
	if (NULL == param)
	{
		return PARAM_ERROR;
	}
	cJSON *p_json_param = cJSON_Parse(param);
	if (p_json_param == NULL)
	{
		return JSON_PARAM_ERROR;
	}
	memset(p_src, 0, sizeof(jy_get_av_stream_res_t));
	cJSON* p_json_data_list  = cJSON_GetObjectItemEx(p_json_param, "data", cJSON_Array);
	if (NULL == p_json_data_list)
	{
		return JSON_NODE_ERROR;
	}
	int nSize = cJSON_GetArraySize(p_json_data_list);
	for (int i = 0; i < nSize; ++i)
	{
		cJSON *p_json_data = cJSON_GetArrayItem(p_json_data_list, i);
		if (NULL == p_json_data)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_json_channel = cJSON_GetObjectItemEx(p_json_data, "chn", cJSON_Number);
		if (p_json_channel != NULL)
		{
			p_src->stream[i].channel_id = p_json_channel->valueint;
		}
		cJSON* p_json_stream = cJSON_GetObjectItemEx(p_json_data, "stream", cJSON_Number);
		if (p_json_stream != NULL)
		{
			p_src->stream[i].stream_id = p_json_stream->valueint;
		}
		cJSON* p_json_height = cJSON_GetObjectItemEx(p_json_data, "height", cJSON_Number);
		if (p_json_height != NULL)
		{
			p_src->stream[i].video_height = p_json_height->valueint;
		}
		cJSON* p_json_width = cJSON_GetObjectItemEx(p_json_data, "width", cJSON_Number);
		if (p_json_width != NULL)
		{
			p_src->stream[i].video_width = p_json_width->valueint;
		}
		cJSON* p_json_framerate = cJSON_GetObjectItemEx(p_json_data, "fps", cJSON_Number);
		if (p_json_framerate != NULL)
		{
			p_src->stream[i].frame_rate = p_json_framerate->valueint;
		}
		cJSON* p_json_bittype = cJSON_GetObjectItemEx(p_json_data, "bit_type", cJSON_Number);
		if (p_json_bittype != NULL)
		{
			p_src->stream[i].bit_rate_type = p_json_bittype->valueint;
		}
		cJSON* p_json_bitrate = cJSON_GetObjectItemEx(p_json_data, "bps", cJSON_Number);
		if (p_json_bitrate != NULL)
		{
			p_src->stream[i].bit_rate = p_json_bitrate->valueint;
		}
		cJSON* p_json_quality = cJSON_GetObjectItemEx(p_json_data, "quality", cJSON_Number);
		if (p_json_quality != NULL)
		{
			p_src->stream[i].quality = p_json_quality->valueint;
		}
		cJSON* p_json_iframe_interval = cJSON_GetObjectItemEx(p_json_data, "if_int", cJSON_Number);
		if (p_json_iframe_interval != NULL)
		{
			p_src->stream[i].i_frame_interval = p_json_iframe_interval->valueint;
		}
		cJSON* p_json_iframe_unit = cJSON_GetObjectItemEx(p_json_data, "i_unit", cJSON_Number);
		if (p_json_iframe_unit != NULL)
		{
			p_src->stream[i].i_frame_interval_unit = p_json_iframe_unit->valueint;
		}
		cJSON* p_json_video_encodetype = cJSON_GetObjectItemEx(p_json_data, "v_enc", cJSON_Number);
		if (p_json_video_encodetype != NULL)
		{
			p_src->stream[i].video_encoder_type = p_json_video_encodetype->valueint;
		}
		cJSON* p_json_video_encodelevel = cJSON_GetObjectItemEx(p_json_data, "v_enc_level", cJSON_Number);
		if (p_json_video_encodelevel != NULL)
		{
			p_src->stream[i].video_encode_level = p_json_video_encodelevel->valueint;
		}
		cJSON* p_json_audio_encodetype = cJSON_GetObjectItemEx(p_json_data, "a_enc", cJSON_Number);
		if (p_json_audio_encodetype != NULL)
		{
			p_src->stream[i].audio_encoder_type = p_json_audio_encodetype->valueint;
		}
		cJSON* p_json_streamname = cJSON_GetObjectItemEx(p_json_data, "streamname", cJSON_String);
		if (p_json_streamname != NULL)
		{
			strcpy(p_src->stream[i].stream_name, p_json_streamname->valuestring);
		}
		++p_src->stream_num;
	}
	cJSON_Delete(p_json_param);
	return 0;
}

int json_perser_osd_param(char *param, jy_dev_osd_user_param_t *p_src)
{
	if (NULL == param)
	{
		return PARAM_ERROR;
	}
	cJSON *p_json_param = cJSON_Parse(param);
	if (NULL == p_json_param)
	{
		return JSON_PARAM_ERROR;
	}
	memset(p_src, 0, sizeof(jy_dev_osd_user_param_t));
	cJSON* p_json_osd_param = cJSON_GetObjectItemEx(p_json_param, "OSDUserParam", cJSON_Object);
	if (NULL != p_json_osd_param)
	{
		cJSON* p_camera_id = cJSON_GetObjectItemEx(p_json_osd_param, "CameraId", cJSON_Number);
		if (NULL != p_camera_id)
		{
			p_src->camera_id = p_camera_id->valueint;
		}
		cJSON* p_json_global_param = cJSON_GetObjectItemEx(p_json_osd_param, "OSDGlobalParam", cJSON_Object);
		if (NULL != p_json_global_param)
		{
			cJSON* p_time_format_id = cJSON_GetObjectItemEx(p_json_global_param, "TimeFormatID", cJSON_Number);
			if (NULL != p_time_format_id)
			{
				p_src->osd_global_param.time_format_id = p_time_format_id->valueint;
			}
			cJSON* p_osd_font_alpha = cJSON_GetObjectItemEx(p_json_global_param, "OSDFontAlpha", cJSON_Number);
			if (NULL != p_osd_font_alpha)
			{
				p_src->osd_global_param.osd_font_alpha = p_osd_font_alpha->valueint;
			}
			cJSON* p_inverse_flag = cJSON_GetObjectItemEx(p_json_global_param, "InverseFlag", cJSON_True);
			if (NULL != p_inverse_flag)
			{
				p_src->osd_global_param.inverse_flag = p_inverse_flag->valueint;
			}
			else
			{
				p_inverse_flag = cJSON_GetObjectItemEx(p_json_global_param, "InverseFlag", cJSON_False);
				if (NULL != p_inverse_flag)
				{
					p_src->osd_global_param.inverse_flag = p_inverse_flag->valueint;
				}
			}
			cJSON* p_channel_id = cJSON_GetObjectItemEx(p_json_global_param, "ChannelId", cJSON_Number);
			if (NULL != p_channel_id)
			{
				p_src->osd_global_param.channel_id = p_channel_id->valueint;
			}
			cJSON* p_twelve_hours = cJSON_GetObjectItemEx(p_json_global_param, "TwelveHoursFlag", cJSON_Number);
			if (NULL != p_twelve_hours)
			{
				p_src->osd_global_param.twelve_hours_flag = p_twelve_hours->valueint;
			}
			cJSON* p_week_flag = cJSON_GetObjectItemEx(p_json_global_param, "WeekFlag", cJSON_Number);
			if (NULL != p_week_flag)
			{
				p_src->osd_global_param.week_flag = p_week_flag->valueint;
			}
			cJSON* p_osd_font_color = cJSON_GetObjectItemEx(p_json_global_param, "OSDFontColor", cJSON_Object);
			if (NULL != p_osd_font_color)
			{
				cJSON* p_font_r = cJSON_GetObjectItemEx(p_osd_font_color, "R", cJSON_Number);
				if (NULL != p_font_r)
				{
					p_src->osd_global_param.font_color.n_r = p_font_r->valueint;
				}
				cJSON* p_font_g = cJSON_GetObjectItemEx(p_osd_font_color, "G", cJSON_Number);
				if (NULL != p_font_g)
				{
					p_src->osd_global_param.font_color.n_g = p_font_g->valueint;
				}
				cJSON* p_font_b = cJSON_GetObjectItemEx(p_osd_font_color, "B", cJSON_Number);
				if (NULL != p_font_b)
				{
					p_src->osd_global_param.font_color.n_b = p_font_b->valueint;
				}
			}
			cJSON* p_osd_inverse_color = cJSON_GetObjectItemEx(p_json_global_param, "OSDFontInverseColor", cJSON_Object);
			if (NULL != p_osd_inverse_color)
			{
				cJSON* p_inverse_r = cJSON_GetObjectItemEx(p_osd_inverse_color, "R", cJSON_Number);
				if (NULL != p_inverse_r)
				{
					p_src->osd_global_param.font_inverse_color.n_r = p_inverse_r->valueint;
				}
				cJSON* p_inverse_g = cJSON_GetObjectItemEx(p_osd_inverse_color, "G", cJSON_Number);
				if (NULL != p_inverse_g)
				{
					p_src->osd_global_param.font_inverse_color.n_g = p_inverse_g->valueint;
				}
				cJSON* p_inverse_b = cJSON_GetObjectItemEx(p_osd_inverse_color, "B", cJSON_Number);
				if (NULL != p_inverse_b)
				{
					p_src->osd_global_param.font_inverse_color.n_b = p_inverse_b->valueint;
				}
			}
		}
		cJSON* p_canvas_proper_list = cJSON_GetObjectItemEx(p_json_osd_param, "CanvasProperList", cJSON_Array);
		if (NULL == p_canvas_proper_list)
		{
			return JSON_NODE_ERROR;
		}
		int nSize = cJSON_GetArraySize(p_canvas_proper_list);
		for (int i = 0; i < nSize; ++i)
		{
			cJSON *p_canvas_proper = cJSON_GetArrayItem(p_canvas_proper_list, i);
			if (NULL == p_canvas_proper)
			{
				return JSON_ARRAY_ERROR;
			}
			cJSON* p_front_width = cJSON_GetObjectItemEx(p_canvas_proper, "FrontWidth", cJSON_Number);
			if (NULL != p_front_width)
			{
				p_src->canvas_proper_list[i].front_width = p_front_width->valueint;
			}
			cJSON* p_front_height = cJSON_GetObjectItemEx(p_canvas_proper, "FrontHeight", cJSON_Number);
			if (NULL != p_front_height)
			{
				p_src->canvas_proper_list[i].front_height = p_front_height->valueint;
			}
			cJSON* p_align_mode = cJSON_GetObjectItemEx(p_canvas_proper, "AlignMode", cJSON_Number);
			if (NULL != p_align_mode)
			{
				p_src->canvas_proper_list[i].align_mode = p_align_mode->valueint;
			}
			cJSON* p_area_id = cJSON_GetObjectItemEx(p_canvas_proper, "AreaID", cJSON_Number);
			if (NULL != p_area_id)
			{
				p_src->canvas_proper_list[i].area_id = p_area_id->valueint;
			}
			cJSON* p_json_area_param = cJSON_GetObjectItemEx(p_canvas_proper, "AreaParam", cJSON_Object);
			if (NULL != p_json_area_param)
			{
				cJSON* p_top_x = cJSON_GetObjectItemEx(p_json_area_param, "TopX", cJSON_Number);
				if (NULL != p_top_x)
				{
					p_src->canvas_proper_list[i].area_param.top_x = p_top_x->valuedouble;
				}
				cJSON* p_top_y = cJSON_GetObjectItemEx(p_json_area_param, "TopY", cJSON_Number);
				if (NULL != p_top_y)
				{
					p_src->canvas_proper_list[i].area_param.top_y = p_top_y->valuedouble;
				}
				cJSON* p_width = cJSON_GetObjectItemEx(p_json_area_param, "Width", cJSON_Number);
				if (NULL != p_width)
				{
					p_src->canvas_proper_list[i].area_param.width = p_width->valuedouble;
				}
				cJSON* p_height = cJSON_GetObjectItemEx(p_json_area_param, "Height", cJSON_Number);
				if (NULL != p_height)
				{
					p_src->canvas_proper_list[i].area_param.height = p_height->valuedouble;
				}
			}
			cJSON* p_json_osd_info_list = cJSON_GetObjectItemEx(p_canvas_proper, "OSDInfoList", cJSON_Array);
			if (NULL == p_json_osd_info_list)
			{
				return JSON_NODE_ERROR;
			}
			int nInfoSize = cJSON_GetArraySize(p_json_osd_info_list);
			for (int j = 0; j < nInfoSize; ++j)
			{
				cJSON *p_osd_info = cJSON_GetArrayItem(p_json_osd_info_list, j);
				if (NULL == p_osd_info)
				{
					return JSON_ARRAY_ERROR;
				}
				cJSON* p_info_area_id = cJSON_GetObjectItemEx(p_osd_info, "AreaID", cJSON_Number);
				if (NULL != p_info_area_id)
				{
					p_src->canvas_proper_list[i].osd_info[j].area_id = p_info_area_id->valueint;
				}
				cJSON* p_arrow_id = cJSON_GetObjectItemEx(p_osd_info, "ArrowID", cJSON_Number);
				if (NULL != p_arrow_id)
				{
					p_src->canvas_proper_list[i].osd_info[j].arrow_id = p_arrow_id->valueint;
				}
				cJSON* p_type = cJSON_GetObjectItemEx(p_osd_info, "Type", cJSON_Number);
				if (NULL != p_type)
				{
					p_src->canvas_proper_list[i].osd_info[j].type = p_type->valueint;
				}
				cJSON* p_enable_flag = cJSON_GetObjectItemEx(p_osd_info, "EnableFlag", cJSON_True);
				if (NULL != p_enable_flag)
				{
					p_src->canvas_proper_list[i].osd_info[j].enable_flag = p_enable_flag->valueint;
				}
				else
				{
					p_enable_flag = cJSON_GetObjectItemEx(p_osd_info, "EnableFlag", cJSON_False);
					if (NULL != p_enable_flag)
					{
						p_src->canvas_proper_list[i].osd_info[j].enable_flag = p_enable_flag->valueint;
					}
				}
				cJSON* p_show_mode = cJSON_GetObjectItemEx(p_osd_info, "ShowMode", cJSON_Number);
				if (NULL != p_show_mode)
				{
					p_src->canvas_proper_list[i].osd_info[j].show_mode = p_show_mode->valueint;
				}
				cJSON* p_info = cJSON_GetObjectItemEx(p_osd_info, "Info", cJSON_String);
				if (NULL != p_info)
				{
					strcpy(p_src->canvas_proper_list[i].osd_info[j].info, p_info->valuestring);
				}
				++p_src->canvas_proper_list[i].osd_info_list_num;
			}
			++p_src->canvas_proper_num;
		}
	}
	cJSON_Delete(p_json_param);
	return 0;
}

int json_perser_net_param(char *param, jy_dev_net_param_list_t *p_src)
{
	if (NULL == param)
	{
		return PARAM_ERROR;
	}
	cJSON* p_json_param = cJSON_Parse(param);
	if (p_json_param == NULL)
	{
		return JSON_PARAM_ERROR;
	}
	memset(p_src, 0, sizeof(jy_dev_net_param_list_t));
	cJSON* p_root = cJSON_GetObjectItemEx(p_json_param, "data", cJSON_Array);
	if (p_root == NULL)
	{
		return JSON_NODE_ERROR;
	}
	int arraysize = cJSON_GetArraySize(p_root);
	p_src->size = arraysize;
	for (int i = 0;i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_root, i);
		cJSON* p_json_netid = cJSON_GetObjectItemEx(item, "netid", cJSON_Number);
		if (p_json_netid != NULL)
		{
			p_src->net_param[i].m_nNetId = p_json_netid->valueint;
		}
		cJSON* p_json_worktype = cJSON_GetObjectItemEx(item, "worktype", cJSON_Number);
		if (p_json_worktype != NULL)
		{
			p_src->net_param[i].m_nWorkingType = p_json_worktype->valueint;
		}
		cJSON* p_json_dhcp = cJSON_GetObjectItem(item, "dhcp");
		if (p_json_dhcp != NULL)
		{
			p_src->net_param[i].m_bDHCP = (BOOL)p_json_dhcp->valueint;
		}
		cJSON* p_json_ipprotover = cJSON_GetObjectItemEx(item, "ip_proto", cJSON_String);
		if (p_json_ipprotover != NULL)
		{
			if (0 == strncmp("IPv4", p_json_ipprotover->valuestring, 4))
			{
				p_src->net_param[i].m_nIPProtoVer = 1;
			}
			else if (0 == strncmp("IPv6", p_json_ipprotover->valuestring, 4))
			{
				p_src->net_param[i].m_nIPProtoVer = 2;
			}
		}
		cJSON* p_json_dns1 = cJSON_GetObjectItemEx(item, "dns1", cJSON_String);
		if (p_json_dns1 != NULL)
		{
			strcpy(p_src->net_param[i].m_strPrimaryDNSIp, p_json_dns1->valuestring);
		}
		cJSON* p_json_dns2 = cJSON_GetObjectItemEx(item, "dns2", cJSON_String);
		if (p_json_dns2 != NULL)
		{
			strcpy(p_src->net_param[i].m_strSpareDNSIp, p_json_dns2->valuestring);
		}
		cJSON* p_json_ip = cJSON_GetObjectItemEx(item, "ip", cJSON_String);
		if (p_json_ip != NULL)
		{
			strcpy(p_src->net_param[i].m_strLocalIp, p_json_ip->valuestring);
		}
		cJSON* p_json_netmask = cJSON_GetObjectItemEx(item, "netmask", cJSON_String);
		if (p_json_netmask != NULL) 
		{
			strcpy(p_src->net_param[i].m_strLocalSubnetMask, p_json_netmask->valuestring);
		}
		cJSON* p_json_gw = cJSON_GetObjectItemEx(item, "gw", cJSON_String);
		if (p_json_gw != NULL) 
		{
			strcpy(p_src->net_param[i].m_strGateway, p_json_gw->valuestring);
		}
	}
	cJSON_Delete(p_json_param);
	return 0;
}

int json_perser_port_param(char *param, jy_dev_port_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (NULL == p_root)
	{
		return JSON_PARAM_ERROR;
	}
	cJSON* p_control_port = cJSON_GetObjectItemEx(p_root, "ControlPort", cJSON_Number);
	if (p_control_port)
	{
		p_src->m_nControlPort = p_control_port->valueint;
	}
	cJSON* p_tcp_av_port = cJSON_GetObjectItemEx(p_root, "TCPAVPort", cJSON_Number);
	if (p_tcp_av_port)
	{
		p_src->m_nTCPAVPort = p_tcp_av_port->valueint;
	}
	cJSON* p_rtsp_port = cJSON_GetObjectItemEx(p_root, "RTSPPort", cJSON_Number);
	if (p_rtsp_port)
	{
		p_src->m_nRTSPPort = p_rtsp_port->valueint;
	}
	cJSON* p_rtp_port = cJSON_GetObjectItemEx(p_root, "RTPPort", cJSON_Number);
	if (p_rtp_port)
	{
		p_src->m_nRTPPort = p_rtp_port->valueint;
	}
	cJSON* p_rtcp_port = cJSON_GetObjectItemEx(p_root, "RTCPPort", cJSON_Number);
	if (p_rtcp_port)
	{
		p_src->m_nRTCPPort= p_rtcp_port->valueint;
	}
	cJSON* p_register_port = cJSON_GetObjectItemEx(p_root, "RegisterPort", cJSON_Number);
	if (p_register_port)
	{
		p_src->m_nRegisterPort= p_register_port->valueint;
	}
	cJSON* p_http_port = cJSON_GetObjectItemEx(p_root, "HttpPort", cJSON_Number);
	if (p_http_port)
	{
		p_src->m_nHttpPort= p_http_port->valueint;
	}
	cJSON* p_reserver1_port = cJSON_GetObjectItemEx(p_root, "ReservePort1", cJSON_Number);
	if (p_reserver1_port)
	{
		p_src->m_nReservePort1= p_reserver1_port->valueint;
	}
	cJSON* p_reserver2_port = cJSON_GetObjectItemEx(p_root, "ReservePort2", cJSON_Number);
	if (p_reserver2_port)
	{
		p_src->m_nReservePort2= p_reserver2_port->valueint;
	}
	cJSON* p_reserver3_port = cJSON_GetObjectItemEx(p_root, "ReservePort3", cJSON_Number);
	if (p_reserver3_port)
	{
		p_src->m_nReservePort3= p_reserver3_port->valueint;
	}
	cJSON* p_reserver4_port = cJSON_GetObjectItemEx(p_root, "ReservePort4", cJSON_Number);
	if (p_reserver4_port)
	{
		p_src->m_nReservePort4 = p_reserver4_port->valueint;
	}
	cJSON* p_ssl_port = cJSON_GetObjectItemEx(p_root, "SslControlPort", cJSON_Number);
	if (p_ssl_port)
	{
		p_src->m_nSslControlPort = p_ssl_port->valueint;
	}
	cJSON* p_https_port = cJSON_GetObjectItemEx(p_root, "HttpsPort", cJSON_Number);
	if (p_https_port)
	{
		p_src->m_nHttpsPort = p_https_port->valueint;
	}
	cJSON_Delete(p_root);
	return 0;
}

int json_perser_ai_multi_object_detect_ability(char *param, jy_dev_ai_multi_object_ability_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (NULL == p_root)
	{
		return JSON_PARAM_ERROR;
	}
	cJSON* p_ai_multi = cJSON_GetObjectItemEx(p_root, "AIMultiObjectDetectAbility", cJSON_Object);
	if (NULL != p_ai_multi)
	{
		p_src->face_enable = 0;
		cJSON* p_face_enable = cJSON_GetObjectItemEx(p_ai_multi, "FaceEnable", cJSON_True);
		if (NULL != p_face_enable)
		{
			p_src->face_enable = p_face_enable->valueint;
		}
		p_src->upbody_enable = 0;
		cJSON* p_upbody_enable = cJSON_GetObjectItemEx(p_ai_multi, "UpBodyEnable", cJSON_True);
		if (NULL != p_upbody_enable)
		{
			p_src->upbody_enable = p_upbody_enable->valueint;
		}
		p_src->fullbody_enable = 0;
		cJSON* p_fullbody_enable = cJSON_GetObjectItemEx(p_ai_multi, "UpBodyEnable", cJSON_True);
		if (NULL != p_fullbody_enable)
		{
			p_src->fullbody_enable = p_fullbody_enable->valueint;
		}
		p_src->plate_enable = 0;
		cJSON* p_plate_enable = cJSON_GetObjectItemEx(p_ai_multi, "PlateEnable", cJSON_True);
		if (NULL != p_plate_enable)
		{
			p_src->plate_enable = p_plate_enable->valueint;
		}
		p_src->vehicle_enable = 0;
		cJSON* p_vehicle_enable = cJSON_GetObjectItemEx(p_ai_multi, "VehicleEnable", cJSON_True);
		if (NULL != p_vehicle_enable)
		{
			p_src->vehicle_enable = p_vehicle_enable->valueint;
		}
	}
	cJSON_Delete(p_root);
	return 0;
}

int json_perser_ai_multi_object_detect_param(char *param, jy_dev_ai_multi_object_param_t *p_src)
{
	cJSON* p_json_root = cJSON_Parse(param);
	if (p_json_root == NULL)
	{
		return PARAM_ERROR;
	}
	cJSON* p_root = cJSON_GetObjectItemEx(p_json_root, "AIMultiObjectDetectParam", cJSON_Object);
	if (p_root == NULL)
	{
		return JSON_PARAM_ERROR;
	}

	cJSON* p_json_face_enable = cJSON_GetObjectItemEx(p_root, "FaceEnable", cJSON_True);
	if (NULL != p_json_face_enable)
	{
		p_src->face_enable = p_json_face_enable->valueint;
	}
	cJSON* p_json_upbody_enable = cJSON_GetObjectItemEx(p_root, "UpBodyEnable", cJSON_True);
	if (NULL != p_json_upbody_enable)
	{
		p_src->upbody_enable = p_json_upbody_enable->valueint;
	}
	cJSON* p_json_fullbody_enable = cJSON_GetObjectItemEx(p_root, "FullBodyEnable", cJSON_True);
	if (NULL != p_json_fullbody_enable)
	{
		p_src->fullbody_enable = p_json_fullbody_enable->valueint;
	}
	cJSON* p_json_plate_enable = cJSON_GetObjectItemEx(p_root, "PlateEnable", cJSON_True);
	if (NULL != p_json_plate_enable)
	{
		p_src->plate_enable = p_json_plate_enable->valueint;
	}
	cJSON* p_json_vehicle_enable = cJSON_GetObjectItemEx(p_root, "VehicleEnable", cJSON_True);
	if (NULL != p_json_vehicle_enable)
	{
		p_src->vehicle_enable = p_json_vehicle_enable->valueint;
	}
	cJSON* p_json_pitch_degree = cJSON_GetObjectItemEx(p_root, "PitchDegree", cJSON_Number);
	if (NULL != p_json_pitch_degree)
	{
		p_src->pitch_degree = p_json_pitch_degree->valueint;
	}
	cJSON* p_json_yaw_degree = cJSON_GetObjectItemEx(p_root, "YawDegree", cJSON_Number);
	if (NULL != p_json_yaw_degree)
	{
		p_src->yaw_degree = p_json_yaw_degree->valueint;
	}
	cJSON* p_json_tilt_degree = cJSON_GetObjectItemEx(p_root, "TiltDegree", cJSON_Number);
	if (NULL != p_json_tilt_degree)
	{
		p_src->tilt_degree = p_json_tilt_degree->valueint;
	}
	cJSON* p_json_pitch_mode = cJSON_GetObjectItemEx(p_root, "SnapPictureMode", cJSON_Number);
	if (NULL != p_json_pitch_mode)
	{
		p_src->snap_picture_mode = p_json_pitch_mode->valueint;
	}
	cJSON* p_json_pitch_num = cJSON_GetObjectItemEx(p_root, "SnapPictureNum", cJSON_Number);
	if (NULL != p_json_pitch_num)
	{
		p_src->snap_picture_num = p_json_pitch_num->valueint;
	}
	cJSON* p_json_consume_pictrue_mode = cJSON_GetObjectItemEx(p_root, "ConsumePictrueMode", cJSON_Number);
	if (NULL != p_json_consume_pictrue_mode)
	{
		p_src->consume_pictrue_mode = p_json_consume_pictrue_mode->valueint;
	}
	cJSON* p_json_show_object_enable = cJSON_GetObjectItemEx(p_root, "ShowObjectEnable", cJSON_True);
	if (NULL != p_json_show_object_enable)
	{
		p_src->show_object_enable = p_json_show_object_enable->valueint;
	}
	cJSON* p_json_show_area_enable = cJSON_GetObjectItemEx(p_root, "ShowAreaEnable", cJSON_True);
	if (NULL != p_json_show_area_enable)
	{
		p_src->show_area_enable = p_json_show_area_enable->valueint;
	}
	cJSON* p_json_ftp_up_enable = cJSON_GetObjectItemEx(p_root, "FtpUploadEnable", cJSON_True);
	if (NULL != p_json_ftp_up_enable)
	{
		p_src->ftp_upload_enable = p_json_ftp_up_enable->valueint;
	}
	cJSON* p_json_ftp_full_enable = cJSON_GetObjectItemEx(p_root, "FtpUploadFullViewEnable", cJSON_True);
	if (NULL != p_json_ftp_full_enable)
	{
		p_src->ftp_upload_full_enable = p_json_ftp_full_enable->valueint;
	}
	cJSON* p_json_upload_interval = cJSON_GetObjectItemEx(p_root, "UploadInterval", cJSON_Number);
	if (NULL != p_json_upload_interval)
	{
		p_src->upload_interval = p_json_upload_interval->valueint;
	}
	cJSON* p_json_reliability = cJSON_GetObjectItemEx(p_root, "Reliability", cJSON_Number);
	if (NULL != p_json_reliability)
	{
		p_src->reliabilty = p_json_reliability->valueint;
	}
	cJSON* p_json_face_min_width = cJSON_GetObjectItemEx(p_root, "FaceMinPixelWidth", cJSON_Number);
	if (NULL != p_json_face_min_width)
	{
		p_src->face_min_width = p_json_face_min_width->valueint;
	}
	cJSON* p_json_face_max_width = cJSON_GetObjectItemEx(p_root, "FaceMaxPixelWidth", cJSON_Number);
	if (NULL != p_json_face_max_width)
	{
		p_src->face_max_width = p_json_face_max_width->valueint;
	}
	cJSON* p_json_upbody_min_width = cJSON_GetObjectItemEx(p_root, "UpBodyMinPixelWidth", cJSON_Number);
	if (NULL != p_json_upbody_min_width)
	{
		p_src->upbody_min_width = p_json_upbody_min_width->valueint;
	}
	cJSON* p_json_upbody_max_width = cJSON_GetObjectItemEx(p_root, "UpBodyMaxPixelWidth", cJSON_Number);
	if (NULL != p_json_upbody_max_width)
	{
		p_src->upbody_max_width = p_json_upbody_max_width->valueint;
	}
	cJSON* p_json_fullbody_min_width = cJSON_GetObjectItemEx(p_root, "FullBodyMinPixelWidth", cJSON_Number);
	if (NULL != p_json_fullbody_min_width)
	{
		p_src->fullbody_min_width = p_json_fullbody_min_width->valueint;
	}
	cJSON* p_json_fullbody_max_width = cJSON_GetObjectItemEx(p_root, "FullBodyMaxPixelWidth", cJSON_Number);
	if (NULL != p_json_fullbody_max_width)
	{
		p_src->fullbody_max_width = p_json_fullbody_max_width->valueint;
	}
	cJSON* p_json_plate_min_width = cJSON_GetObjectItemEx(p_root, "PlateMinPixelWidth", cJSON_Number);
	if (NULL != p_json_plate_min_width)
	{
		p_src->plate_min_width = p_json_plate_min_width->valueint;
	}
	cJSON* p_json_plate_max_width = cJSON_GetObjectItemEx(p_root, "PlateMaxPixelWidth", cJSON_Number);
	if (NULL != p_json_plate_max_width)
	{
		p_src->plate_max_width = p_json_plate_max_width->valueint;
	}
	cJSON* p_json_vehicle_min_width = cJSON_GetObjectItemEx(p_root, "VehicleMinPixelWidth", cJSON_Number);
	if (NULL != p_json_vehicle_min_width)
	{
		p_src->vehicle_min_width = p_json_vehicle_min_width->valueint;
	}
	cJSON* p_json_vehicle_max_width = cJSON_GetObjectItemEx(p_root, "VehicleMaxPixelWidth", cJSON_Number);
	if (NULL != p_json_vehicle_max_width)
	{
		p_src->vehicle_max_width = p_json_vehicle_max_width->valueint;
	}
	cJSON* p_json_picture_quality = cJSON_GetObjectItemEx(p_root, "PictureQuality", cJSON_Number);
	if (NULL != p_json_picture_quality)
	{
		p_src->pic_quality = p_json_picture_quality->valueint;
	}
	cJSON* p_json_attr_enable = cJSON_GetObjectItemEx(p_root, "AttrEnable", cJSON_True);
	if (NULL != p_json_attr_enable)
	{
		p_src->attr_enable = p_json_attr_enable->valueint;
	}
	cJSON* p_json_pic_osd_enable = cJSON_GetObjectItemEx(p_root, "PictureOSDEnable", cJSON_True);
	if (NULL != p_json_pic_osd_enable)
	{
		p_src->pic_osd_enable = p_json_pic_osd_enable->valueint;
	}

	cJSON* p_json_ly_flag = cJSON_GetObjectItemEx(p_root, "LYFlag", cJSON_True);
	if (NULL != p_json_ly_flag)
	{
		p_src->ly_flag = p_json_ly_flag->valueint;
	}

	cJSON* p_json_refer_brightness = cJSON_GetObjectItemEx(p_root, "ReferBrightness", cJSON_Number);
	if (NULL != p_json_refer_brightness)
	{
		p_src->refer_brightness = p_json_refer_brightness->valueint;
	}
	cJSON* p_json_continue_time = cJSON_GetObjectItemEx(p_root, "ContinueTime", cJSON_Number);
	if (NULL != p_json_continue_time)
	{
		p_src->continue_time = p_json_continue_time->valueint;
	}

	cJSON* p_json_mask_check_enable = cJSON_GetObjectItemEx(p_root, "MaskCheckEnable", cJSON_True);
	if (NULL != p_json_mask_check_enable)
	{
		p_src->mask_check_enable = p_json_mask_check_enable->valueint;
	}

	cJSON* p_json_live_detection_enable = cJSON_GetObjectItemEx(p_root, "LiveDetectionEnable", cJSON_True);
	if (NULL != p_json_live_detection_enable)
	{
		p_src->live_detection_enable = p_json_live_detection_enable->valueint;
	}

	cJSON* p_json_face_exposure_enable = cJSON_GetObjectItemEx(p_root, "FaceExposureEnable", cJSON_True);
	if (NULL != p_json_face_exposure_enable)
	{
		p_src->face_exposure_enable = p_json_face_exposure_enable->valueint;
	}

	cJSON* p_json_algo_version = cJSON_GetObjectItemEx(p_root, "AlgoVersion", cJSON_String);
	if (NULL != p_json_algo_version)
	{
		strcpy(p_src->algo_version, p_json_algo_version->valuestring);
	}
	cJSON* p_json_timelist = cJSON_GetObjectItemEx(p_root, "ScheduleTimeList", cJSON_Array);
	if (NULL == p_json_timelist)
	{
		return JSON_NODE_ERROR;
	}
	int time_list_size = cJSON_GetArraySize(p_json_timelist);
	for (int i = 0; i < time_list_size; ++i)
	{
		cJSON *item = cJSON_GetArrayItem(p_json_timelist, i);
		if (NULL == item)
		{
			assert(0);
		}
		cJSON* p_starttime = cJSON_GetObjectItemEx(item, "StartTime", cJSON_Number);
		if (p_starttime != NULL)
		{
			p_src->schedule_time_list[i].start_time = p_starttime->valueint;
		}
		cJSON* p_endtime = cJSON_GetObjectItemEx(item, "EndTime", cJSON_Number);
		if (p_endtime != NULL)
		{
			p_src->schedule_time_list[i].end_time = p_endtime->valueint;
		}
		cJSON* p_week = cJSON_GetObjectItemEx(item, "WeekDay", cJSON_Number);
		if (p_week != NULL)
		{
			p_src->schedule_time_list[i].week_day = p_week->valueint;
		}
		++p_src->schedule_time_size;
	}
	cJSON* p_json_polygon_area_list = cJSON_GetObjectItemEx(p_root, "PolygonAreaList", cJSON_Array);
	if (NULL == p_json_polygon_area_list)
	{
		return JSON_NODE_ERROR;
	}
	int polygon_area_list_size = cJSON_GetArraySize(p_json_polygon_area_list);
	for (int i = 0; i < polygon_area_list_size; ++i)
	{
		cJSON *item = cJSON_GetArrayItem(p_json_polygon_area_list, i);
		cJSON* p_xval = cJSON_GetObjectItemEx(item, "Xval", cJSON_Number);
		if (p_xval != NULL)
		{
			p_src->polygon_area_list[i].x_val = p_xval->valuedouble;
		}
		cJSON* p_yval = cJSON_GetObjectItemEx(item, "Yval", cJSON_Number);
		if (p_yval != NULL)
		{
			p_src->polygon_area_list[i].y_val = p_yval->valuedouble;
		}
		++p_src->polygon_area_size;
	}

	cJSON* p_json_polygon_area_param_list = cJSON_GetObjectItemEx(p_root, "PolygonAreaParamList", cJSON_Array);
	if (NULL == p_json_polygon_area_param_list)
	{
		return JSON_NODE_ERROR;
	}
	int polygon_area_param_list_size = cJSON_GetArraySize(p_json_polygon_area_param_list);
	for (int i = 0; i < polygon_area_param_list_size; i++)
	{
		cJSON *item_area = cJSON_GetArrayItem(p_json_polygon_area_param_list, i);
		cJSON* p_areaid = cJSON_GetObjectItemEx(item_area, "AreaId", cJSON_Number);
		if (p_areaid != NULL)
		{
			p_src->polygon_area_param_list[i].area_id = p_areaid->valueint;
		}
		cJSON* p_min_pix = cJSON_GetObjectItemEx(item_area, "FaceMinPixelWidth", cJSON_Number);
		if (p_min_pix != NULL)
		{
			p_src->polygon_area_param_list[i].face_min_width = p_min_pix->valueint;
		}
		cJSON* p_max_pix = cJSON_GetObjectItemEx(item_area, "FaceMaxPixelWidth", cJSON_Number);
		if (p_max_pix != NULL)
		{
			p_src->polygon_area_param_list[i].face_max_width = p_max_pix->valueint;
		}
		cJSON* p_json_point_list = cJSON_GetObjectItemEx(item_area, "point_list", cJSON_Array);
		if (NULL == p_json_point_list)
		{
			return JSON_NODE_ERROR;
		}
		int point_size = cJSON_GetArraySize(p_json_point_list);
		for (int j = 0; j < point_size; ++j)
		{
			cJSON *item = cJSON_GetArrayItem(p_json_point_list, j);
			cJSON* p_xval = cJSON_GetObjectItemEx(item, "Xval", cJSON_Number);
			if (p_xval != NULL)
			{
				p_src->polygon_area_param_list[i].polygon_area_list[j].x_val = p_xval->valuedouble;
			}
			cJSON* p_yval = cJSON_GetObjectItemEx(item, "Yval", cJSON_Number);
			if (p_yval != NULL)
			{
				p_src->polygon_area_param_list[i].polygon_area_list[j].y_val = p_yval->valuedouble;
			}
			++p_src->polygon_area_param_list[i].polygon_area_size;
		}
		++p_src->polygon_area_param_size;
	}
	cJSON* p_json_alarm_list = cJSON_GetObjectItemEx(p_root, "TemperatureAlarmDeploymentList", cJSON_Array);
	if (NULL == p_json_alarm_list)
	{
		return JSON_NODE_ERROR;
	}
	int alarm_list_size = cJSON_GetArraySize(p_json_alarm_list);
	for (int i = 0; i < alarm_list_size; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_json_alarm_list, i);
		cJSON* p_SourceType = cJSON_GetObjectItemEx(item, "SourceType", cJSON_Number);
		if (p_SourceType != NULL)
		{
			p_src->temp_alarm_deployment_list[i].source_type = p_SourceType->valueint;
		}
		cJSON* p_SourceID = cJSON_GetObjectItemEx(item, "SourceID", cJSON_Number);
		if (p_SourceID != NULL)
		{
			p_src->temp_alarm_deployment_list[i].source_id = p_SourceID->valueint;
		}
		cJSON* p_AlarmRule = cJSON_GetObjectItemEx(item, "AlarmRule", cJSON_Number);
		if (p_AlarmRule != NULL)
		{
			p_src->temp_alarm_deployment_list[i].alarm_rule = p_AlarmRule->valueint;
		}
		cJSON* p_AlarmThreshold = cJSON_GetObjectItemEx(item, "AlarmThreshold", cJSON_Number);
		if (p_AlarmThreshold != NULL)
		{
			p_src->temp_alarm_deployment_list[i].alarm_threshold = p_AlarmThreshold->valuedouble;
		}
		cJSON* p_AlarmInterval = cJSON_GetObjectItemEx(item, "AlarmInterval", cJSON_Number);
		if (p_AlarmInterval != NULL)
		{
			p_src->temp_alarm_deployment_list[i].alarm_interval = p_AlarmInterval->valueint;
		}

		cJSON* p_json_timesonlist = cJSON_GetObjectItemEx(item, "ScheduleTimeList", cJSON_Array);
		if (NULL == p_json_timesonlist)
		{
			return JSON_NODE_ERROR;
		}
		int timeson_list_size = cJSON_GetArraySize(p_json_timesonlist);
		for (int j = 0; j < timeson_list_size; j++)
		{
			cJSON *item1 = cJSON_GetArrayItem(p_json_timesonlist, j);
			cJSON* p_starttime = cJSON_GetObjectItemEx(item1, "StartTime", cJSON_Number);
			if (p_starttime != NULL)
			{
				p_src->temp_alarm_deployment_list[i].schedule_time_list[j].start_time = p_starttime->valueint;
			}
			cJSON* p_endtime = cJSON_GetObjectItemEx(item1, "EndTime", cJSON_Number);
			if (p_endtime != NULL)
			{
				p_src->temp_alarm_deployment_list[i].schedule_time_list[j].end_time = p_endtime->valueint;
			}
			cJSON* p_week = cJSON_GetObjectItemEx(item1, "WeekDay", cJSON_Number);
			if (p_week != NULL)
			{
				p_src->temp_alarm_deployment_list[i].schedule_time_list[j].week_day = p_week->valueint;
			}
			++p_src->temp_alarm_deployment_list[i].schedule_time_size;
		}
		cJSON* p_linkage_list = cJSON_GetObjectItemEx(item, "AlarmLinkageParamList", cJSON_Array);
		if (NULL == p_linkage_list)
		{
			return JSON_NODE_ERROR;
		}
		int linkage_list_size = cJSON_GetArraySize(p_linkage_list);
		for (int j = 0; j < linkage_list_size; j++)
		{
			cJSON *item2 = cJSON_GetArrayItem(p_linkage_list, j);
			cJSON* p_ActionType = cJSON_GetObjectItemEx(item2, "ActionType", cJSON_Number);
			if (p_ActionType != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_linkage_list[j].action_type = p_ActionType->valueint;
			}
			cJSON* p_ActionID = cJSON_GetObjectItemEx(item2, "ActionID", cJSON_Number);
			if (p_ActionID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_linkage_list[j].action_id = p_ActionID->valueint;
			}
			++p_src->temp_alarm_deployment_list[i].alarm_linkage_size;
		}
		cJSON* p_out_list = cJSON_GetObjectItemEx(item, "AlarmOutActionList", cJSON_Array);
		if (NULL == p_out_list)
		{
			return JSON_NODE_ERROR;
		}
		int out_list_size = cJSON_GetArraySize(p_out_list);
		for (int j = 0; j < out_list_size; j++)
		{
			cJSON *item3 = cJSON_GetArrayItem(p_out_list, j);
			cJSON* p_DeviceId = cJSON_GetObjectItemEx(item3, "DeviceId", cJSON_String);
			if (p_DeviceId != NULL)
			{
				strcpy(p_src->temp_alarm_deployment_list[i].alarm_out_list[j].device_id, p_DeviceId->valuestring);
			}
			cJSON* p_AlarmOutId = cJSON_GetObjectItemEx(item3, "AlarmOutId", cJSON_Number);
			if (p_AlarmOutId != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_out_id = p_AlarmOutId->valueint;
			}
			cJSON* p_AlarmOutFlag = cJSON_GetObjectItemEx(item3, "AlarmOutFlag", cJSON_Number);
			if (p_AlarmOutFlag != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_out_flag = p_AlarmOutFlag->valueint;
			}
			cJSON* p_EventTypeId = cJSON_GetObjectItemEx(item3, "EventTypeId", cJSON_Number);
			if (p_EventTypeId != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].event_type_id = p_EventTypeId->valueint;
			}
			cJSON* p_AlarmTime = cJSON_GetObjectItemEx(item3, "AlarmTime", cJSON_Number);
			if (p_AlarmTime != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_time = p_AlarmTime->valueint;
			}
			cJSON* p_ActionType = cJSON_GetObjectItemEx(item3, "ActionType", cJSON_Number);
			if (p_ActionType != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].action_type = p_ActionType->valueint;
			}
			cJSON* p_ActionID = cJSON_GetObjectItemEx(item3, "ActionID", cJSON_Number);
			if (p_ActionID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].alarm_out_list[j].action_id = p_ActionID->valueint;
			}
			cJSON* p_ActionName = cJSON_GetObjectItemEx(item3, "ActionName", cJSON_String);
			if (p_ActionName != NULL)
			{
				strcpy(p_src->temp_alarm_deployment_list[i].alarm_out_list[j].action_name, p_AlarmTime->valuestring);
			}
			++p_src->temp_alarm_deployment_list[i].alarm_out_size;
		}
		cJSON* p_record_list = cJSON_GetObjectItemEx(item, "RecordActionParamList", cJSON_Array);
		if (NULL == p_record_list)
		{
			return JSON_NODE_ERROR;
		}
		int record_list_size = cJSON_GetArraySize(p_record_list);
		for (int j = 0; j < record_list_size; j++)
		{
			cJSON *item4 = cJSON_GetArrayItem(p_record_list, j);
			cJSON* p_PreRecordFlag = cJSON_GetObjectItemEx(item4, "PreRecordFlag", cJSON_Number);
			if (p_PreRecordFlag != NULL)
			{
				p_src->temp_alarm_deployment_list[i].record_param_list[j].pre_record_flag = p_PreRecordFlag->valueint;
			}
			cJSON* p_DelayRecordTime = cJSON_GetObjectItemEx(item4, "DelayRecordTime", cJSON_Number);
			if (p_DelayRecordTime != NULL)
			{
				p_src->temp_alarm_deployment_list[i].record_param_list[j].delay_record_time = p_DelayRecordTime->valueint;
			}
			cJSON* p_ActionType = cJSON_GetObjectItemEx(item4, "ActionType", cJSON_Number);
			if (p_ActionType != NULL)
			{
				p_src->temp_alarm_deployment_list[i].record_param_list[j].action_type = p_ActionType->valueint;
			}
			cJSON* p_ActionID = cJSON_GetObjectItemEx(item4, "ActionID", cJSON_Number);
			if (p_ActionID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].record_param_list[j].action_id = p_ActionID->valueint;
			}
			cJSON* p_ActionName = cJSON_GetObjectItemEx(item4, "ActionName", cJSON_String);
			if (p_ActionName != NULL)
			{
				strcpy(p_src->temp_alarm_deployment_list[i].record_param_list[j].action_name, p_ActionName->valuestring);
			}
			++p_src->temp_alarm_deployment_list[i].record_param_size;
		}
		cJSON* p_ptz_list = cJSON_GetObjectItemEx(item, "PTZActionParamList", cJSON_Array);
		if (NULL == p_ptz_list)
		{
			return JSON_NODE_ERROR;
		}
		int ptz_list_size = cJSON_GetArraySize(p_ptz_list);
		for (int j = 0; j < ptz_list_size; j++)
		{
			cJSON *item5 = cJSON_GetArrayItem(p_ptz_list, j);
			cJSON* p_PTZActionType = cJSON_GetObjectItemEx(item5, "PTZActionType", cJSON_Number);
			if (p_PTZActionType != NULL)
			{
				p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_action_type = p_PTZActionType->valueint;
			}
			cJSON* p_PTZActionID = cJSON_GetObjectItemEx(item5, "PTZActionID", cJSON_Number);
			if (p_PTZActionID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_action_id = p_PTZActionID->valueint;
			}
			cJSON* p_PTZChannelID = cJSON_GetObjectItemEx(item5, "PTZChannelID", cJSON_Number);
			if (p_PTZChannelID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_chn_id = p_PTZChannelID->valueint;
			}
			cJSON* p_ActionType = cJSON_GetObjectItemEx(item5, "ActionType", cJSON_Number);
			if (p_ActionType != NULL)
			{
				p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].action_type = p_ActionType->valueint;
			}
			cJSON* p_ActionID = cJSON_GetObjectItemEx(item5, "ActionID", cJSON_Number);
			if (p_ActionID != NULL)
			{
				p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].action_id = p_ActionID->valueint;
			}
			cJSON* p_ActionName = cJSON_GetObjectItemEx(item5, "ActionName", cJSON_String);
			if (p_ActionName != NULL)
			{
				strcpy(p_src->temp_alarm_deployment_list[i].ptz_action_param_list[j].action_name, p_ActionName->valuestring);
			}
			++p_src->temp_alarm_deployment_list[i].ptz_action_size;
		}
		++p_src->temp_alarm_deployment_size;
	}
	cJSON_Delete(p_json_root);
	return 0;
}

int json_perser_thermal_cap(char *param, jy_dev_thermal_cap_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (NULL == p_root)
	{
		return JSON_PARAM_ERROR;
	}
	cJSON* p_is_thermal = cJSON_GetObjectItemEx(p_root, "is_thermal", cJSON_Number);
	if (p_is_thermal)
	{
		p_src->is_thermal = p_is_thermal->valueint;
	}
	cJSON* p_max_area_num = cJSON_GetObjectItemEx(p_root, "max_measure_area_num", cJSON_Number);
	if (p_max_area_num)
	{
		p_src->max_measure_area_num = p_max_area_num->valueint;
	}
	cJSON* p_measure_range_list = cJSON_GetObjectItemEx(p_root, "measure_range_list", cJSON_Array);
	if (NULL != p_measure_range_list)
	{
		return JSON_NODE_ERROR;
	}
	int measure_range_size = cJSON_GetArraySize(p_measure_range_list);
	for (int i = 0; i < measure_range_size; ++i)
	{
		cJSON *p_measure_range = cJSON_GetArrayItem(p_measure_range_list, i);
		if (p_measure_range)
		{
			cJSON* p_id = cJSON_GetObjectItemEx(p_measure_range, "id", cJSON_Number);
			if (p_id)
			{
				p_src->measure_range_list[i].range_id = p_id->valueint;
			}
			cJSON* p_max_value = cJSON_GetObjectItemEx(p_measure_range, "max_value", cJSON_Number);
			if (p_max_value)
			{
				p_src->measure_range_list[i].max_value = p_max_value->valueint;
			}
			cJSON* p_min_value = cJSON_GetObjectItemEx(p_measure_range, "min_value", cJSON_Number);
			if (p_min_value)
			{
				p_src->measure_range_list[i].min_value = p_min_value->valueint;
			}
			++p_src->measure_range_size;
		}
	}

	cJSON_Delete(p_root);
	return 0;
}

int json_perser_thermal_param(char *param, jy_dev_thermal_param_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (NULL == p_root)
	{
		return JSON_PARAM_ERROR;
	}
	cJSON* p_is_open_tempera = cJSON_GetObjectItemEx(p_root, "is_open_tempera_measure", cJSON_Number);
	if (p_is_open_tempera)
	{
		p_src->is_open_tempera_measure = p_is_open_tempera->valueint;
	}
	cJSON* p_thermal_measure_mode = cJSON_GetObjectItemEx(p_root, "thermal_measure_mode", cJSON_Number);
	if (p_thermal_measure_mode)
	{
		p_src->thermal_measure_mode = p_thermal_measure_mode->valueint;
	}
	cJSON* p_cur_preset_id = cJSON_GetObjectItemEx(p_root, "cur_preset_id", cJSON_Number);
	if (p_cur_preset_id)
	{
		p_src->cur_preset_id = p_cur_preset_id->valueint;
	}
	cJSON* p_physics_info = cJSON_GetObjectItemEx(p_root, "physics_info", cJSON_Number);
	if (p_physics_info)
	{
		p_src->physics_info = p_physics_info->valuedouble;
	}
	cJSON* p_tempr_show_mode = cJSON_GetObjectItemEx(p_root, "area_feature_tempr_show_m", cJSON_Number);
	if (p_tempr_show_mode)
	{
		p_src->tempr_show_mode = p_tempr_show_mode->valueint;
	}
	cJSON* p_display_mode = cJSON_GetObjectItemEx(p_root, "display_mode", cJSON_Number);
	if (p_display_mode)
	{
		p_src->display_mode = p_display_mode->valueint;
	}
	cJSON* p_osd_fontborder_enable = cJSON_GetObjectItemEx(p_root, "osd_fontborder_enable", cJSON_Number);
	if (p_osd_fontborder_enable)
	{
		p_src->osd_fontborder_enable = p_osd_fontborder_enable->valueint;
	}
	cJSON* p_fontsize_mode = cJSON_GetObjectItemEx(p_root, "fontsize_mode", cJSON_Number);
	if (p_fontsize_mode)
	{
		p_src->fontsize_mode = p_fontsize_mode->valueint;
	}
	cJSON* p_custom_enable = cJSON_GetObjectItemEx(p_root, "custom_osd_colorEnable", cJSON_Number);
	if (p_custom_enable)
	{
		p_src->custom_osd_color_enable = p_custom_enable->valueint;
	}
	cJSON* p_facecolor_enable = cJSON_GetObjectItemEx(p_root, "facecolor_enable", cJSON_Number);
	if (p_facecolor_enable)
	{
		p_src->facecolor_enable = p_facecolor_enable->valueint;
	}
	cJSON* p_envit_tempera = cJSON_GetObjectItemEx(p_root, "envit_temperature", cJSON_Number);
	if (p_envit_tempera)
	{
		p_src->envit_tempera = p_envit_tempera->valuedouble;
	}
	cJSON* p_cavity_tempera = cJSON_GetObjectItemEx(p_root, "cavity_temoperature", cJSON_Number);
	if (p_cavity_tempera)
	{
		p_src->cavity_tempera = p_cavity_tempera->valuedouble;
	}
	cJSON* p_is_al_area = cJSON_GetObjectItemEx(p_root, "is_display_al_area", cJSON_Number);
	if (p_is_al_area)
	{
		p_src->is_display_al_area = p_is_al_area->valueint;
	}
	cJSON* p_tempera_unit = cJSON_GetObjectItemEx(p_root, "temperature_unit", cJSON_Number);
	if (p_tempera_unit)
	{
		p_src->tempera_unit = p_tempera_unit->valueint;
	}
	cJSON* p_distance = cJSON_GetObjectItemEx(p_root, "distance", cJSON_Number);
	if (p_distance)
	{
		p_src->distance = p_distance->valuedouble;
	}
	cJSON* p_threshold = cJSON_GetObjectItemEx(p_root, "threshold", cJSON_Number);
	if (p_threshold)
	{
		p_src->threshold = p_threshold->valuedouble;
	}
	cJSON* p_alarm_int = cJSON_GetObjectItemEx(p_root, "alarm_int", cJSON_Number);
	if (p_alarm_int)
	{
		p_src->alarm_int = p_alarm_int->valueint;
	}
	cJSON* p_ave_tempera_corre = cJSON_GetObjectItemEx(p_root, "ave_temperature_correction", cJSON_Number);
	if (p_ave_tempera_corre)
	{
		p_src->ave_tempera_corre = p_ave_tempera_corre->valueint;
	}
	cJSON* p_abnormal_tempera_filter = cJSON_GetObjectItemEx(p_root, "abnormal_temperature_filter", cJSON_Number);
	if (p_abnormal_tempera_filter)
	{
		p_src->abnormal_tempera_filter = p_abnormal_tempera_filter->valueint;
	}
	cJSON* p_measure_mode = cJSON_GetObjectItemEx(p_root, "measure_mode", cJSON_Number);
	if (p_measure_mode)
	{
		p_src->measure_mode = p_measure_mode->valueint;
	}
	cJSON* p_alarm_delay = cJSON_GetObjectItemEx(p_root, "alarm_delay", cJSON_Number);
	if (p_alarm_delay)
	{
		p_src->alarm_delay = p_alarm_delay->valueint;
	}
	cJSON* p_drc_mode = cJSON_GetObjectItemEx(p_root, "drc_mode", cJSON_Number);
	if (p_drc_mode)
	{
		p_src->drc_mode = p_drc_mode->valueint;
	}
	cJSON* p_manual_drc_id = cJSON_GetObjectItemEx(p_root, "manual_drcmode_rangeid", cJSON_Number);
	if (p_manual_drc_id)
	{
		p_src->manual_drc_id = p_manual_drc_id->valueint;
	}
	cJSON* p_manual_drc_max = cJSON_GetObjectItemEx(p_root, "manual_drcmode_range_max", cJSON_Number);
	if (p_manual_drc_max)
	{
		p_src->manual_drc_range_max = p_manual_drc_max->valuedouble;
	}
	cJSON* p_manual_drc_min = cJSON_GetObjectItemEx(p_root, "manual_drcmode_range_min", cJSON_Number);
	if (p_manual_drc_min)
	{
		p_src->manual_drc_range_min = p_manual_drc_min->valuedouble;
	}
	cJSON* p_manual_ori_max = cJSON_GetObjectItemEx(p_root, "manual_drcmode_ori_max", cJSON_Number);
	if (p_manual_ori_max)
	{
		p_src->manual_drc_ori_max = p_manual_ori_max->valuedouble;
	}
	cJSON* p_manual_ori_min = cJSON_GetObjectItemEx(p_root, "manual_drcmode_ori_min", cJSON_Number);
	if (p_manual_ori_min)
	{
		p_src->manual_drc_ori_min = p_manual_ori_min->valuedouble;
	}
	cJSON* p_measure_rangeid = cJSON_GetObjectItemEx(p_root, "measure_rangeid", cJSON_Number);
	if (p_measure_rangeid)
	{
		p_src->measure_rangeid = p_measure_rangeid->valueint;
	}
	cJSON* p_osd_fontcolor_r = cJSON_GetObjectItemEx(p_root, "osd_fontcolor_r", cJSON_Number);
	if (p_osd_fontcolor_r)
	{
		p_src->osd_fontcolor_r = p_osd_fontcolor_r->valueint;
	}
	cJSON* p_osd_fontcolor_g = cJSON_GetObjectItemEx(p_root, "osd_fontcolor_g", cJSON_Number);
	if (p_osd_fontcolor_g)
	{
		p_src->osd_fontcolor_g = p_osd_fontcolor_g->valueint;
	}
	cJSON* p_osd_fontcolor_b = cJSON_GetObjectItemEx(p_root, "osd_fontcolor_b", cJSON_Number);
	if (p_osd_fontcolor_b)
	{
		p_src->osd_fontcolor_b = p_osd_fontcolor_b->valueint;
	}
	cJSON* p_large_enable = cJSON_GetObjectItemEx(p_root, "large_enable", cJSON_Number);
	if (p_large_enable)
	{
		p_src->large_enable = p_large_enable->valueint;
	}
	cJSON* p_large_tempera = cJSON_GetObjectItemEx(p_root, "large_temoperature", cJSON_Number);
	if (p_large_tempera)
	{
		p_src->large_tempera = p_large_tempera->valueint;
	}
	cJSON* p_largecolor_r = cJSON_GetObjectItemEx(p_root, "largecolor_r", cJSON_Number);
	if (p_largecolor_r)
	{
		p_src->largecolor_r = p_largecolor_r->valueint;
	}
	cJSON* p_largecolor_g = cJSON_GetObjectItemEx(p_root, "largecolor_g", cJSON_Number);
	if (p_largecolor_g)
	{
		p_src->largecolor_g = p_largecolor_g->valueint;
	}
	cJSON* p_largecolor_b = cJSON_GetObjectItemEx(p_root, "largecolor_b", cJSON_Number);
	if (p_largecolor_b)
	{
		p_src->largecolor_b = p_largecolor_b->valueint;
	}
	cJSON* p_range_enable = cJSON_GetObjectItemEx(p_root, "range_enable", cJSON_Number);
	if (p_range_enable)
	{
		p_src->range_enable = p_range_enable->valueint;
	}
	cJSON* p_range_min_tempera = cJSON_GetObjectItemEx(p_root, "range_min_temoperature", cJSON_Number);
	if (p_range_min_tempera)
	{
		p_src->range_min_tempera = p_range_min_tempera->valueint;
	}
	cJSON* p_range_max_tempera = cJSON_GetObjectItemEx(p_root, "range_max_temoperature", cJSON_Number);
	if (p_range_max_tempera)
	{
		p_src->range_max_tempera = p_range_max_tempera->valueint;
	}
	cJSON* p_range_color_r = cJSON_GetObjectItemEx(p_root, "range_color_r", cJSON_Number);
	if (p_range_color_r)
	{
		p_src->range_color_r = p_range_color_r->valueint;
	}
	cJSON* p_range_color_g = cJSON_GetObjectItemEx(p_root, "range_color_g", cJSON_Number);
	if (p_range_color_g)
	{
		p_src->range_color_g = p_range_color_g->valueint;
	}
	cJSON* p_range_color_b = cJSON_GetObjectItemEx(p_root, "range_color_b", cJSON_Number);
	if (p_range_color_b)
	{
		p_src->range_color_b = p_range_color_b->valueint;
	}
	cJSON* p_small_enable = cJSON_GetObjectItemEx(p_root, "small_enable", cJSON_Number);
	if (p_small_enable)
	{
		p_src->small_enable = p_small_enable->valueint;
	}
	cJSON* p_small_tempera = cJSON_GetObjectItemEx(p_root, "small_temoperature", cJSON_Number);
	if (p_small_tempera)
	{
		p_src->small_tempera = p_small_tempera->valueint;
	}
	cJSON* p_small_color_r = cJSON_GetObjectItemEx(p_root, "small_color_r", cJSON_Number);
	if (p_small_color_r)
	{
		p_src->small_color_r = p_small_color_r->valueint;
	}
	cJSON* p_small_color_g = cJSON_GetObjectItemEx(p_root, "small_color_g", cJSON_Number);
	if (p_small_color_g)
	{
		p_src->small_color_g = p_small_color_g->valueint;
	}
	cJSON* p_small_color_b = cJSON_GetObjectItemEx(p_root, "small_color_b", cJSON_Number);
	if (p_small_color_b)
	{
		p_src->small_color_b = p_small_color_b->valueint;
	}
	cJSON* p_mix_stream_mode = cJSON_GetObjectItemEx(p_root, "mix_stream_mode", cJSON_Number);
	if (p_mix_stream_mode)
	{
		p_src->mix_stream_mode = p_mix_stream_mode->valueint;
	}
	cJSON* p_raw_upload = cJSON_GetObjectItemEx(p_root, "raw_upload_interval", cJSON_Number);
	if (p_raw_upload)
	{
		p_src->raw_upload_interval = p_raw_upload->valueint;
	}
	cJSON* p_prevent_mode = cJSON_GetObjectItemEx(p_root, "prevent_overheat_mode", cJSON_Number);
	if (p_prevent_mode)
	{
		p_src->prevent_overheat_mode = p_prevent_mode->valueint;
	}
	cJSON* p_duration = cJSON_GetObjectItemEx(p_root, "keepclose_duration", cJSON_Number);
	if (p_duration)
	{
		p_src->keepclose_duration = p_duration->valueint;
	}
	cJSON* p_control_cover = cJSON_GetObjectItemEx(p_root, "control_cover", cJSON_Number);
	if (p_control_cover)
	{
		p_src->control_cover = p_control_cover->valueint;
	}
	cJSON* p_mormal_range_max = cJSON_GetObjectItemEx(p_root, "NormalTemperatureRange_Max", cJSON_Number);
	if (p_mormal_range_max)
	{
		p_src->normal_temp_range_max = p_mormal_range_max->valuedouble;
	}
	cJSON* p_mormal_range_min = cJSON_GetObjectItemEx(p_root, "NormalTemperatureRange_Min", cJSON_Number);
	if (p_mormal_range_min)
	{
		p_src->normal_temp_range_min = p_mormal_range_min->valuedouble;
	}
	cJSON* p_length_unit = cJSON_GetObjectItemEx(p_root, "LengthUnit", cJSON_Number);
	if (p_length_unit)
	{
		p_src->length_unit = p_length_unit->valueint;
	}
	cJSON* p_temp_area_mode = cJSON_GetObjectItemEx(p_root, "TempAreaMode", cJSON_Number);
	if (p_temp_area_mode)
	{
		p_src->temp_area_mode = p_temp_area_mode->valueint;
	}
	cJSON_Delete(p_root);
	return 0;
}

static void perser_area_point_info(char *area_src, jy_dev_area_point_list_t *area_point_list)
{
	int area_num = 0;
	char point_src[32] = { 0 };
	int point_size = 0;
	int src_size = strlen(area_src);
	memset(area_point_list, 0, sizeof(jy_dev_area_point_list_t));
	if (src_size > 0)
	{
		for (int i = 0; i < src_size + 1; ++i)
		{
			if ((area_src[i] == '\0') || (area_src[i] == ';'))
			{
				sscanf(point_src, " ( %lf , %lf ) ", &area_point_list->area_point[area_num].point_x, &area_point_list->area_point[area_num].point_y);
				point_size = 0;
				memset(&point_src, 0, 16);
				++area_num;
			}
			else
			{
				point_src[point_size] = area_src[i];
				++point_size;
			}
		}
	}
	else
	{
		area_num = 0;
	}
	area_point_list->list_size = area_num;
}

int json_perser_thermal_area_measure(char *param, jy_dev_thermal_area_measure_t *p_src)
{
	if (NULL == param)
	{
		return PARAM_ERROR;
	}
	cJSON *p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		return JSON_PARAM_ERROR;
	}
	memset(p_src, 0, sizeof(jy_get_av_stream_res_t));
	cJSON* p_measure_mode = cJSON_GetObjectItemEx(p_root, "measure_mode", cJSON_Number);
	if (p_measure_mode)
	{
		p_src->measure_mode = p_measure_mode->valueint;
	}
	cJSON* p_preset_id = cJSON_GetObjectItemEx(p_root, "preset_id", cJSON_Number);
	if (p_preset_id)
	{
		p_src->preset_id = p_preset_id->valueint;
	}
	cJSON* p_json_area_list = cJSON_GetObjectItemEx(p_root, "area_list", cJSON_Array);
	if (NULL == p_json_area_list)
	{
		return JSON_NODE_ERROR;
	}
	int nSize = cJSON_GetArraySize(p_json_area_list);
	for (int i = 0; i < nSize; ++i)
	{
		cJSON *p_json_area = cJSON_GetArrayItem(p_json_area_list, i);
		if (NULL == p_json_area)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_source_id = cJSON_GetObjectItemEx(p_json_area, "source_id", cJSON_Number);
		if (p_source_id != NULL)
		{
			p_src->area_info_list[i].source_id = p_source_id->valueint;
		}
		cJSON* p_source_type = cJSON_GetObjectItemEx(p_json_area, "source_type", cJSON_Number);
		if (p_source_type != NULL)
		{
			p_src->area_info_list[i].source_type = p_source_type->valueint;
		}
		cJSON* p_area_id = cJSON_GetObjectItemEx(p_json_area, "area_id", cJSON_Number);
		if (p_area_id != NULL)
		{
			p_src->area_info_list[i].area_id = p_area_id->valueint;
		}
		cJSON* p_area_name = cJSON_GetObjectItemEx(p_json_area, "area_name", cJSON_String);
		if (p_area_name != NULL)
		{
			strcpy(p_src->area_info_list[i].area_name, p_area_name->valuestring);
		}
		cJSON* p_alarm_enable = cJSON_GetObjectItemEx(p_json_area, "alarm_enable_flag", cJSON_Number);
		if (p_alarm_enable != NULL)
		{
			p_src->area_info_list[i].alarm_enable_flag = p_alarm_enable->valueint;
		}
		cJSON* p_alarm_type = cJSON_GetObjectItemEx(p_json_area, "alarm_type", cJSON_Number);
		if (p_alarm_type != NULL)
		{
			p_src->area_info_list[i].alarm_type = p_alarm_type->valueint;
		}
		cJSON* p_warning_alarm = cJSON_GetObjectItemEx(p_json_area, "warning_alarm_value", cJSON_Number);
		if (p_warning_alarm != NULL)
		{
			p_src->area_info_list[i].warning_alarm_value = p_warning_alarm->valueint;
		}
		cJSON* p_alarm_max = cJSON_GetObjectItemEx(p_json_area, "alarm_max_value", cJSON_Number);
		if (p_alarm_max != NULL)
		{
			p_src->area_info_list[i].alarm_max_value = p_alarm_max->valueint;
		}
		cJSON* p_alarm_value = cJSON_GetObjectItemEx(p_json_area, "alarm_value", cJSON_Number);
		if (p_alarm_value != NULL)
		{
			p_src->area_info_list[i].alarm_value = p_alarm_value->valueint;
		}
		cJSON* p_emissivity = cJSON_GetObjectItemEx(p_json_area, "emissivity", cJSON_Number);
		if (p_emissivity != NULL)
		{
			p_src->area_info_list[i].emissivity = p_emissivity->valuedouble;
		}
		cJSON* p_target_space = cJSON_GetObjectItemEx(p_json_area, "target_space", cJSON_Number);
		if (p_target_space != NULL)
		{
			p_src->area_info_list[i].target_space = p_target_space->valueint;
		}
		cJSON* p_area_en_flag = cJSON_GetObjectItemEx(p_json_area, "area_en_flag", cJSON_Number);
		if (p_area_en_flag != NULL)
		{
			p_src->area_info_list[i].area_en_flag = p_area_en_flag->valueint;
		}
		cJSON* p_area_shape_type = cJSON_GetObjectItemEx(p_json_area, "area_shape_type", cJSON_Number);
		if (p_area_shape_type != NULL)
		{
			p_src->area_info_list[i].area_shape_type = p_area_shape_type->valueint;
		}
		cJSON* p_point_coordinate = cJSON_GetObjectItemEx(p_json_area, "point_coordinate", cJSON_String);
		if (p_point_coordinate != NULL)
		{
			perser_area_point_info(p_point_coordinate->valuestring, &p_src->area_info_list[i].area_point_list);
		}
		++p_src->area_size;
	}
	cJSON_Delete(p_root);
	return 0;
}

int json_perser_disk_alarm(char *param, jy_dev_disk_alarm_param_list_t *p_src)
{
	cJSON* p_json_root = cJSON_Parse(param);
	if (p_json_root == NULL)
	{
		return PARAM_ERROR;
	}
	cJSON* p_json_disk_alarm_list = cJSON_GetObjectItemEx(p_json_root, "disk_alarm_list", cJSON_Array);
	if (p_json_disk_alarm_list == NULL)
	{
		return JSON_NODE_ERROR;
	}
	int ndisk_alarm_size = cJSON_GetArraySize(p_json_disk_alarm_list);
	for (int i = 0; i < ndisk_alarm_size; ++i)
	{
		cJSON *p_json_disk_alarm = cJSON_GetArrayItem(p_json_disk_alarm_list, i);
		if (NULL == p_json_disk_alarm)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_json_source_para = cJSON_GetObjectItemEx(p_json_disk_alarm, "source_para", cJSON_Object);
		if (NULL == p_json_source_para)
		{
			return JSON_NODE_ERROR;
		}
		cJSON* p_json_src_type = cJSON_GetObjectItemEx(p_json_source_para, "src_type", cJSON_Number);
		if (NULL != p_json_src_type)
		{
			p_src->disk_param_list[i].source_type = p_json_src_type->valueint;
		}
		cJSON* p_json_src_id = cJSON_GetObjectItemEx(p_json_source_para, "src_id", cJSON_Number);
		if (NULL != p_json_src_id)
		{
			p_src->disk_param_list[i].source_id = p_json_src_id->valueint;
		}
		cJSON* p_json_src_name = cJSON_GetObjectItemEx(p_json_source_para, "src_name", cJSON_String);
		if (NULL != p_json_src_name)
		{
			strcpy(p_src->disk_param_list[i].source_name, p_json_src_name->valuestring);
		}
		cJSON* p_json_enable = cJSON_GetObjectItemEx(p_json_source_para, "enable", cJSON_Number);
		if (NULL != p_json_enable)
		{
			p_src->disk_param_list[i].enable = p_json_enable->valueint;
		}
		cJSON* p_json_alarm_inval = cJSON_GetObjectItemEx(p_json_source_para, "alarm_inval", cJSON_Number);
		if (NULL != p_json_alarm_inval)
		{
			p_src->disk_param_list[i].alarm_interval = p_json_alarm_inval->valueint;
		}
		cJSON* p_json_full_alarm_enable = cJSON_GetObjectItemEx(p_json_source_para, "full_alarm_enable", cJSON_Number);
		if (NULL != p_json_full_alarm_enable)
		{
			p_src->disk_param_list[i].full_alarm_enable = p_json_full_alarm_enable->valueint;
		}
		cJSON* p_json_alarm_threshold = cJSON_GetObjectItemEx(p_json_source_para, "alarm_threshold", cJSON_Number);
		if (NULL != p_json_alarm_threshold)
		{
			p_src->disk_param_list[i].alarm_threshold = p_json_alarm_threshold->valueint;
		}
		cJSON* p_json_error_alarm_enable = cJSON_GetObjectItemEx(p_json_source_para, "error_alarm_enable", cJSON_Number);
		if (NULL != p_json_error_alarm_enable)
		{
			p_src->disk_param_list[i].error_alarm_enable = p_json_error_alarm_enable->valueint;
		}
		cJSON* p_json_no_disk_alarm_enable = cJSON_GetObjectItemEx(p_json_source_para, "no_disk_alarm_enable", cJSON_Number);
		if (NULL != p_json_no_disk_alarm_enable)
		{
			p_src->disk_param_list[i].no_disk_alarm_enable = p_json_no_disk_alarm_enable->valueint;
		}
		cJSON* p_json_alarm_time = cJSON_GetObjectItemEx(p_json_source_para, "alarm_time", cJSON_Object);
		if (NULL != p_json_alarm_time)
		{
			cJSON* p_json_schedule_time_list = cJSON_GetObjectItemEx(p_json_alarm_time, "schedule_time_list", cJSON_Array);
			if (p_json_schedule_time_list == NULL)
			{
				return JSON_NODE_ERROR;
			}
			int nschedule_time_size = cJSON_GetArraySize(p_json_schedule_time_list);
			for (int j = 0; j < nschedule_time_size; ++j)
			{
				cJSON *p_json_schedule_time = cJSON_GetArrayItem(p_json_schedule_time_list, j);
				if (NULL == p_json_schedule_time)
				{
					return JSON_ARRAY_ERROR;
				}
				cJSON* p_starttime = cJSON_GetObjectItemEx(p_json_schedule_time, "s_time", cJSON_Number);
				if (p_starttime != NULL)
				{
					p_src->disk_param_list[i].schedule_time_list[j].start_time = p_starttime->valueint;
				}
				cJSON* p_endtime = cJSON_GetObjectItemEx(p_json_schedule_time, "e_time", cJSON_Number);
				if (p_endtime != NULL)
				{
					p_src->disk_param_list[i].schedule_time_list[j].end_time = p_endtime->valueint;
				}
				cJSON* p_week = cJSON_GetObjectItemEx(p_json_schedule_time, "weekday", cJSON_Number);
				if (p_week != NULL)
				{
					p_src->disk_param_list[i].schedule_time_list[j].week_day = p_week->valueint;
				}
				++p_src->disk_param_list[i].schedule_time_size;
			}
		}
		cJSON* p_linkage_list = cJSON_GetObjectItemEx(p_json_disk_alarm, "link_para_list", cJSON_Array);
		if (NULL == p_linkage_list)
		{
			return JSON_NODE_ERROR;
		}
		int linkage_list_size = cJSON_GetArraySize(p_linkage_list);
		for (int j = 0; j < linkage_list_size; j++)
		{
			cJSON *p_linkage = cJSON_GetArrayItem(p_linkage_list, j);
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_linkage, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->disk_param_list[i].alarm_linkage_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_linkage, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->disk_param_list[i].alarm_linkage_list[j].action_id = p_act_id->valueint;
			}
			++p_src->disk_param_list[i].alarm_linkage_size;
		}
		cJSON* p_ptz_list = cJSON_GetObjectItemEx(p_json_disk_alarm, "ptz_para_list", cJSON_Array);
		if (NULL == p_ptz_list)
		{
			return JSON_NODE_ERROR;
		}
		int ptz_list_size = cJSON_GetArraySize(p_ptz_list);
		for (int j = 0; j < ptz_list_size; j++)
		{
			cJSON *p_ptz = cJSON_GetArrayItem(p_ptz_list, j);
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_ptz, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->disk_param_list[i].ptz_action_param_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_ptz, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->disk_param_list[i].ptz_action_param_list[j].action_id = p_act_id->valueint;
			}
			cJSON* p_ptz_channel_id = cJSON_GetObjectItemEx(p_ptz, "ptz_channel_id", cJSON_Number);
			if (p_ptz_channel_id != NULL)
			{
				p_src->disk_param_list[i].ptz_action_param_list[j].ptz_chn_id = p_ptz_channel_id->valueint;
			}
			cJSON* p_ptz_act_type = cJSON_GetObjectItemEx(p_ptz, "ptz_act_type", cJSON_Number);
			if (p_ptz_act_type != NULL)
			{
				p_src->disk_param_list[i].ptz_action_param_list[j].ptz_action_type = p_ptz_act_type->valueint;
			}
			cJSON* p_ptz_act_id = cJSON_GetObjectItemEx(p_ptz, "ptz_act_id", cJSON_Number);
			if (p_ptz_act_id != NULL)
			{
				p_src->disk_param_list[i].ptz_action_param_list[j].ptz_action_id = p_ptz_act_id->valueint;
			}
			cJSON* p_act_name = cJSON_GetObjectItemEx(p_ptz, "act_name", cJSON_String);
			if (p_act_name != NULL)
			{
				strcpy(p_src->disk_param_list[i].ptz_action_param_list[j].action_name, p_act_name->valuestring);
			}
			++p_src->disk_param_list[i].ptz_action_size;
		}
		cJSON* p_out_list = cJSON_GetObjectItemEx(p_json_disk_alarm, "alarm_out_para_list", cJSON_Array);
		if (NULL == p_out_list)
		{
			return JSON_NODE_ERROR;
		}
		int out_list_size = cJSON_GetArraySize(p_out_list);
		for (int j = 0; j < out_list_size; j++)
		{
			cJSON *p_out = cJSON_GetArrayItem(p_out_list, j);
			cJSON* p_dev_id = cJSON_GetObjectItemEx(p_out, "dev_id", cJSON_String);
			if (p_dev_id != NULL)
			{
				strcpy(p_src->disk_param_list[i].alarm_out_list[j].device_id, p_dev_id->valuestring);
			}
			cJSON* p_alarm_out_id = cJSON_GetObjectItemEx(p_out, "alarm_out_id", cJSON_Number);
			if (p_alarm_out_id != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].alarm_out_id = p_alarm_out_id->valueint;
			}
			cJSON* p_alarm_out_flag = cJSON_GetObjectItemEx(p_out, "alarm_out_flag", cJSON_Number);
			if (p_alarm_out_flag != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].alarm_out_flag = p_alarm_out_flag->valueint;
			}
			cJSON* p_event_type_id = cJSON_GetObjectItemEx(p_out, "event_type_id", cJSON_Number);
			if (p_event_type_id != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].event_type_id = p_event_type_id->valueint;
			}
			cJSON* p_alarm_time = cJSON_GetObjectItemEx(p_out, "alarm_time", cJSON_Number);
			if (p_alarm_time != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].alarm_time = p_alarm_time->valueint;
			}
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_out, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_out, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->disk_param_list[i].alarm_out_list[j].action_id = p_act_id->valueint;
			}
			cJSON* p_act_name = cJSON_GetObjectItemEx(p_out, "act_name", cJSON_String);
			if (p_act_name != NULL)
			{
				strcpy(p_src->disk_param_list[i].alarm_out_list[j].action_name, p_act_name->valuestring);
			}
			++p_src->disk_param_list[i].alarm_out_size;
		}
		++p_src->num;
	}
	cJSON_Delete(p_json_root);
	return 0;
}

int json_perser_io_alarm(char *param, jy_dev_io_alarm_param_list_t *p_src)
{
	cJSON* p_json_root = cJSON_Parse(param);
	if (p_json_root == NULL)
	{
		return PARAM_ERROR;
	}
	cJSON* p_json_io_alarm_list = cJSON_GetObjectItemEx(p_json_root, "io_alarm_list", cJSON_Array);
	if (p_json_io_alarm_list == NULL)
	{
		return JSON_NODE_ERROR;
	}
	int nio_alarm_size = cJSON_GetArraySize(p_json_io_alarm_list);
	for (int i = 0; i < nio_alarm_size; ++i)
	{
		cJSON *p_json_io_alarm = cJSON_GetArrayItem(p_json_io_alarm_list, i);
		if (NULL == p_json_io_alarm)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_json_insource_para = cJSON_GetObjectItemEx(p_json_io_alarm, "insource_para", cJSON_Object);
		if (NULL == p_json_insource_para)
		{
			return JSON_NODE_ERROR;
		}
		cJSON* p_json_src_type = cJSON_GetObjectItemEx(p_json_insource_para, "src_type", cJSON_Number);
		if (NULL != p_json_src_type)
		{
			p_src->io_param_list[i].source_type = p_json_src_type->valueint;
		}
		cJSON* p_json_src_id = cJSON_GetObjectItemEx(p_json_insource_para, "src_id", cJSON_Number);
		if (NULL != p_json_src_id)
		{
			p_src->io_param_list[i].source_id = p_json_src_id->valueint;
		}
		cJSON* p_json_src_name = cJSON_GetObjectItemEx(p_json_insource_para, "src_name", cJSON_String);
		if (NULL != p_json_src_name)
		{
			strcpy(p_src->io_param_list[i].source_name, p_json_src_name->valuestring);
		}
		cJSON* p_json_enable = cJSON_GetObjectItemEx(p_json_insource_para, "enable", cJSON_Number);
		if (NULL != p_json_enable)
		{
			p_src->io_param_list[i].enable = p_json_enable->valueint;
		}
		cJSON* p_json_alarm_inval = cJSON_GetObjectItemEx(p_json_insource_para, "alarm_inval", cJSON_Number);
		if (NULL != p_json_alarm_inval)
		{
			p_src->io_param_list[i].alarm_interval = p_json_alarm_inval->valueint;
		}
		cJSON* p_json_valid_level = cJSON_GetObjectItemEx(p_json_insource_para, "valid_level", cJSON_Number);
		if (NULL != p_json_valid_level)
		{
			p_src->io_param_list[i].valid_level = p_json_valid_level->valueint;
		}
		cJSON* p_json_alarm_time = cJSON_GetObjectItemEx(p_json_insource_para, "alarm_time", cJSON_Object);
		if (NULL != p_json_alarm_time)
		{
			cJSON* p_json_schedule_time_list = cJSON_GetObjectItemEx(p_json_alarm_time, "schedule_time_list", cJSON_Array);
			if (p_json_schedule_time_list == NULL)
			{
				return JSON_NODE_ERROR;
			}
			int nschedule_time_size = cJSON_GetArraySize(p_json_schedule_time_list);
			for (int j = 0; j < nschedule_time_size; ++j)
			{
				cJSON *p_json_schedule_time = cJSON_GetArrayItem(p_json_schedule_time_list, j);
				if (NULL == p_json_schedule_time)
				{
					return JSON_ARRAY_ERROR;
				}
				cJSON* p_starttime = cJSON_GetObjectItemEx(p_json_schedule_time, "s_time", cJSON_Number);
				if (p_starttime != NULL)
				{
					p_src->io_param_list[i].schedule_time_list[j].start_time = p_starttime->valueint;
				}
				cJSON* p_endtime = cJSON_GetObjectItemEx(p_json_schedule_time, "e_time", cJSON_Number);
				if (p_endtime != NULL)
				{
					p_src->io_param_list[i].schedule_time_list[j].end_time = p_endtime->valueint;
				}
				cJSON* p_week = cJSON_GetObjectItemEx(p_json_schedule_time, "weekday", cJSON_Number);
				if (p_week != NULL)
				{
					p_src->io_param_list[i].schedule_time_list[j].week_day = p_week->valueint;
				}
				++p_src->io_param_list[i].schedule_time_size;
			}
		}
		cJSON* p_linkage_list = cJSON_GetObjectItemEx(p_json_io_alarm, "link_para_list", cJSON_Array);
		if (NULL == p_linkage_list)
		{
			return JSON_NODE_ERROR;
		}
		int linkage_list_size = cJSON_GetArraySize(p_linkage_list);
		for (int j = 0; j < linkage_list_size; j++)
		{
			cJSON *p_linkage = cJSON_GetArrayItem(p_linkage_list, j);
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_linkage, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->io_param_list[i].alarm_linkage_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_linkage, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->io_param_list[i].alarm_linkage_list[j].action_id = p_act_id->valueint;
			}
			++p_src->io_param_list[i].alarm_linkage_size;
		}
		cJSON* p_ptz_list = cJSON_GetObjectItemEx(p_json_io_alarm, "ptz_para_list", cJSON_Array);
		if (NULL == p_ptz_list)
		{
			return JSON_NODE_ERROR;
		}
		int ptz_list_size = cJSON_GetArraySize(p_ptz_list);
		for (int j = 0; j < ptz_list_size; j++)
		{
			cJSON *p_ptz = cJSON_GetArrayItem(p_ptz_list, j);
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_ptz, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->io_param_list[i].ptz_action_param_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_ptz, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->io_param_list[i].ptz_action_param_list[j].action_id = p_act_id->valueint;
			}
			cJSON* p_ptz_channel_id = cJSON_GetObjectItemEx(p_ptz, "ptz_channel_id", cJSON_Number);
			if (p_ptz_channel_id != NULL)
			{
				p_src->io_param_list[i].ptz_action_param_list[j].ptz_chn_id = p_ptz_channel_id->valueint;
			}
			cJSON* p_ptz_act_type = cJSON_GetObjectItemEx(p_ptz, "ptz_act_type", cJSON_Number);
			if (p_ptz_act_type != NULL)
			{
				p_src->io_param_list[i].ptz_action_param_list[j].ptz_action_type = p_ptz_act_type->valueint;
			}
			cJSON* p_ptz_act_id = cJSON_GetObjectItemEx(p_ptz, "ptz_act_id", cJSON_Number);
			if (p_ptz_act_id != NULL)
			{
				p_src->io_param_list[i].ptz_action_param_list[j].ptz_action_id = p_ptz_act_id->valueint;
			}
			cJSON* p_act_name = cJSON_GetObjectItemEx(p_ptz, "act_name", cJSON_String);
			if (p_act_name != NULL)
			{
				strcpy(p_src->io_param_list[i].ptz_action_param_list[j].action_name, p_act_name->valuestring);
			}
			++p_src->io_param_list[i].ptz_action_size;
		}
		cJSON* p_out_list = cJSON_GetObjectItemEx(p_json_io_alarm, "alarm_out_para_list", cJSON_Array);
		if (NULL == p_out_list)
		{
			return JSON_NODE_ERROR;
		}
		int out_list_size = cJSON_GetArraySize(p_out_list);
		for (int j = 0; j < out_list_size; j++)
		{
			cJSON *p_out = cJSON_GetArrayItem(p_out_list, j);
			cJSON* p_dev_id = cJSON_GetObjectItemEx(p_out, "dev_id", cJSON_String);
			if (p_dev_id != NULL)
			{
				strcpy(p_src->io_param_list[i].alarm_out_list[j].device_id, p_dev_id->valuestring);
			}
			cJSON* p_alarm_out_id = cJSON_GetObjectItemEx(p_out, "alarm_out_id", cJSON_Number);
			if (p_alarm_out_id != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].alarm_out_id = p_alarm_out_id->valueint;
			}
			cJSON* p_alarm_out_flag = cJSON_GetObjectItemEx(p_out, "alarm_out_flag", cJSON_Number);
			if (p_alarm_out_flag != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].alarm_out_flag = p_alarm_out_flag->valueint;
			}
			cJSON* p_event_type_id = cJSON_GetObjectItemEx(p_out, "event_type_id", cJSON_Number);
			if (p_event_type_id != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].event_type_id = p_event_type_id->valueint;
			}
			cJSON* p_alarm_time = cJSON_GetObjectItemEx(p_out, "alarm_time", cJSON_Number);
			if (p_alarm_time != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].alarm_time = p_alarm_time->valueint;
			}
			cJSON* p_act_type = cJSON_GetObjectItemEx(p_out, "act_type", cJSON_Number);
			if (p_act_type != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].action_type = p_act_type->valueint;
			}
			cJSON* p_act_id = cJSON_GetObjectItemEx(p_out, "act_id", cJSON_Number);
			if (p_act_id != NULL)
			{
				p_src->io_param_list[i].alarm_out_list[j].action_id = p_act_id->valueint;
			}
			cJSON* p_act_name = cJSON_GetObjectItemEx(p_out, "act_name", cJSON_String);
			if (p_act_name != NULL)
			{
				strcpy(p_src->io_param_list[i].alarm_out_list[j].action_name, p_act_name->valuestring);
			}
			++p_src->io_param_list[i].alarm_out_size;
		}
		++p_src->num;
	}
	cJSON_Delete(p_json_root);
	return 0;
}

int json_perser_mot_alarm_original(char *param, jy_dev_mot_alarm_param_list_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		cJSON_Delete(p_root);
		return PARAM_ERROR;
	}

	int arraysize = cJSON_GetArraySize(p_root);
	p_src->num = arraysize;
	for (int i = 0; i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_root, i);
		cJSON *p_MotionDetectSource = cJSON_GetObjectItemEx(item, "mot_source_param", cJSON_Object);
		if (NULL != item)
		{
			cJSON* p_enable_flag = cJSON_GetObjectItemEx(p_MotionDetectSource, "enable", cJSON_Number);
			if (NULL != p_enable_flag)
			{
				p_src->mot_alarm_list[i].mot_source_param.enable_flag = p_enable_flag->valueint;
			}
			cJSON* p_alarm_interval = cJSON_GetObjectItemEx(p_MotionDetectSource, "alarmval", cJSON_Number);
			if (NULL != p_alarm_interval)
			{
				p_src->mot_alarm_list[i].mot_source_param.alarm_interval = p_alarm_interval->valueint;
			}
			cJSON* p_check_block_num = cJSON_GetObjectItemEx(p_MotionDetectSource, "blocknum", cJSON_Number);
			if (NULL != p_check_block_num)
			{
				p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.check_block_num = p_check_block_num->valueint;
			}
			cJSON* p_sensitivity = cJSON_GetObjectItemEx(p_MotionDetectSource, "sensitivity", cJSON_Number);
			if (NULL != p_sensitivity)
			{
				p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.sensitivity = p_sensitivity->valueint;
			}
			cJSON* p_width_cell_num = cJSON_GetObjectItemEx(p_MotionDetectSource, "widthnum", cJSON_Number);
			if (NULL != p_width_cell_num)
			{
				p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.width_cell_number = p_width_cell_num->valueint;
			}
			cJSON* p_high_cell_num = cJSON_GetObjectItemEx(p_MotionDetectSource, "highnum", cJSON_Number);
			if (NULL != p_high_cell_num)
			{
				p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.high_cell_number = p_high_cell_num->valueint;
			}
			cJSON* p_data = cJSON_GetObjectItemEx(p_MotionDetectSource, "areadata", cJSON_String);
			if (NULL != p_data)
			{
				strcpy(p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.date, p_data->valuestring);
			}

			cJSON* p_ScheduleTimeList = cJSON_GetObjectItemEx(p_MotionDetectSource, "timelist", cJSON_Array);
			if (NULL != p_ScheduleTimeList)
			{
				int arraysize_time = cJSON_GetArraySize(p_ScheduleTimeList);
				p_src->mot_alarm_list[i].mot_source_param.schedule_time_size = arraysize_time;
				for (int j = 0; j < arraysize_time; j++)
				{
					cJSON *item_time = cJSON_GetArrayItem(p_ScheduleTimeList, j);
					cJSON* p_week_day = cJSON_GetObjectItemEx(item_time, "weekday", cJSON_Number);
					if (NULL != p_week_day)
					{
						p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].week_day = p_week_day->valueint;
					}
					cJSON* p_start_time = cJSON_GetObjectItemEx(item_time, "sTime", cJSON_Number);
					if (NULL != p_start_time)
					{
						p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].start_time = p_start_time->valueint;
					}
					cJSON* p_end_time = cJSON_GetObjectItemEx(item_time, "eTime", cJSON_Number);
					if (NULL != p_end_time)
					{
						p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].end_time = p_end_time->valueint;
					}
				}
			}
		}
	}
	return 0;
}

int json_perser_mot_alarm(char *param, jy_dev_mot_alarm_param_list_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		cJSON_Delete(p_root);
		return PARAM_ERROR;
	}

	cJSON* p_MotionDetectEventList = cJSON_GetObjectItemEx(p_root, "MotionDetectEventList", cJSON_Array);
	if (NULL == p_MotionDetectEventList)
	{
		cJSON_Delete(p_root);
		return JSON_NODE_ERROR;
	}

	int arraysize = cJSON_GetArraySize(p_MotionDetectEventList);
	p_src->num = arraysize;
	for (int i = 0; i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_MotionDetectEventList, i);
		cJSON *p_MotionDetectSource = cJSON_GetObjectItemEx(item, "MotionDetectSource", cJSON_Object);
		if (NULL != item)
		{
			cJSON* p_source_type = cJSON_GetObjectItemEx(p_MotionDetectSource, "SourceType", cJSON_Number);
			if (NULL != p_source_type)
			{
				p_src->mot_alarm_list[i].mot_source_param.source_type = p_source_type->valueint;
			}
			cJSON* p_source_id = cJSON_GetObjectItemEx(p_MotionDetectSource, "SourceID", cJSON_Number);
			if (NULL != p_source_id)
			{
				p_src->mot_alarm_list[i].mot_source_param.source_id = p_source_id->valueint;
			}
			cJSON* p_source_name = cJSON_GetObjectItemEx(p_MotionDetectSource, "SourceName", cJSON_String);
			if (NULL != p_source_name)
			{
				strcpy(p_src->mot_alarm_list[i].mot_source_param.source_name, p_source_name->valuestring);
			}
			cJSON* p_enable_flag = cJSON_GetObjectItemEx(p_MotionDetectSource, "EnableFlag", cJSON_Number);
			if (NULL != p_enable_flag)
			{
				p_src->mot_alarm_list[i].mot_source_param.enable_flag = p_enable_flag->valueint;
			}
			cJSON* p_alarm_interval = cJSON_GetObjectItemEx(p_MotionDetectSource, "AlarmInterval", cJSON_Number);
			if (NULL != p_alarm_interval)
			{
				p_src->mot_alarm_list[i].mot_source_param.alarm_interval = p_alarm_interval->valueint;
			}
			cJSON* p_analysis_flag= cJSON_GetObjectItemEx(p_MotionDetectSource, "MotionAnalysisFlag", cJSON_Number);
			if (NULL != p_analysis_flag)
			{
				p_src->mot_alarm_list[i].mot_source_param.mot_analysis_flag = p_analysis_flag->valueint;
			}

			cJSON *p_AlarmTime = cJSON_GetObjectItemEx(p_MotionDetectSource, "AlarmTime", cJSON_Object);
			if (NULL != p_AlarmTime)
			{
				cJSON* p_ScheduleTimeList = cJSON_GetObjectItemEx(p_AlarmTime, "ScheduleTimeList", cJSON_Array);
				if (NULL != p_ScheduleTimeList)
				{
					int arraysize_time = cJSON_GetArraySize(p_ScheduleTimeList);
					p_src->mot_alarm_list[i].mot_source_param.schedule_time_size = arraysize_time;
					for (int j = 0; j < arraysize_time; j++)
					{
						cJSON *item_time = cJSON_GetArrayItem(p_ScheduleTimeList, j);
						cJSON* p_week_day = cJSON_GetObjectItemEx(item_time, "WeekDay", cJSON_Number);
						if (NULL != p_week_day)
						{
							p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].week_day = p_week_day->valueint;
						}
						cJSON* p_start_time = cJSON_GetObjectItemEx(item_time, "StartTime", cJSON_Number);
						if (NULL != p_start_time)
						{
							p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].start_time = p_start_time->valueint;
						}
						cJSON* p_end_time = cJSON_GetObjectItemEx(item_time, "EndTime", cJSON_Number);
						if (NULL != p_end_time)
						{
							p_src->mot_alarm_list[i].mot_source_param.schedule_time_list[j].end_time = p_end_time->valueint;
						}
					}
				}
			}

			cJSON *p_MotionDetectionParam = cJSON_GetObjectItemEx(p_MotionDetectSource, "MotionDetectionParam", cJSON_Object);
			if (NULL != p_MotionDetectionParam)
			{
				cJSON* p_check_block_num = cJSON_GetObjectItemEx(p_MotionDetectionParam, "CheckBlockNum", cJSON_Number);
				if (NULL != p_check_block_num)
				{
					p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.check_block_num = p_check_block_num->valueint;
				}
				cJSON* p_sensitivity = cJSON_GetObjectItemEx(p_MotionDetectionParam, "Sensitivity", cJSON_Number);
				if (NULL != p_sensitivity)
				{
					p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.sensitivity = p_sensitivity->valueint;
				}

				cJSON* p_DetectionArea = cJSON_GetObjectItemEx(p_MotionDetectionParam, "DetectionArea", cJSON_Object);
				if (NULL != p_DetectionArea)
				{
					cJSON* p_width_cell_num = cJSON_GetObjectItemEx(p_DetectionArea, "WidthCellNumber", cJSON_Number);
					if (NULL != p_width_cell_num)
					{
						p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.width_cell_number = p_width_cell_num->valueint;
					}
					cJSON* p_high_cell_num = cJSON_GetObjectItemEx(p_DetectionArea, "HighCellNumber", cJSON_Number);
					if (NULL != p_high_cell_num)
					{
						p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.high_cell_number = p_high_cell_num->valueint;
					}
					cJSON* p_data_length = cJSON_GetObjectItemEx(p_DetectionArea, "DataLength", cJSON_Number);
					if (NULL != p_data_length)
					{
						p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.data_length = p_data_length->valueint;
					}
					cJSON* p_data = cJSON_GetObjectItemEx(p_DetectionArea, "Data", cJSON_String);
					if (NULL != p_data)
					{
						strcpy(p_src->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.date, p_data->valuestring);
					}
				}
			}
		}

		cJSON *p_AlarmLinkageParamList = cJSON_GetObjectItemEx(item, "AlarmLinkageParamList", cJSON_Array);
		if (NULL != p_AlarmLinkageParamList)
		{
			int arraysize_alarm_link = cJSON_GetArraySize(p_AlarmLinkageParamList);
			p_src->mot_alarm_list[i].alarm_linkage_size = arraysize_alarm_link;
			for (int k = 0; k < arraysize_alarm_link; k++)
			{
				cJSON *item_alarm_link = cJSON_GetArrayItem(p_AlarmLinkageParamList, k);
				cJSON* p_action_type = cJSON_GetObjectItemEx(item_alarm_link, "ActionType", cJSON_Number);
				if (NULL != p_action_type)
				{
					p_src->mot_alarm_list[i].alarm_linkage_list[k].action_type = p_action_type->valueint;
				}
				cJSON* p_action_id = cJSON_GetObjectItemEx(item_alarm_link, "ActionID", cJSON_Number);
				if (NULL != p_action_id)
				{
					p_src->mot_alarm_list[i].alarm_linkage_list[k].action_type = p_action_id->valueint;
				}
			}
		}

		cJSON *p_PTZActionParamList = cJSON_GetObjectItemEx(item, "PTZActionParamList", cJSON_Array);
		if (NULL != p_PTZActionParamList)
		{
			int arraysize_ptz_action = cJSON_GetArraySize(p_PTZActionParamList);
			p_src->mot_alarm_list[i].ptz_action_size = arraysize_ptz_action;
			for (int m = 0; m < arraysize_ptz_action; m++)
			{
				cJSON *item_ptz_action = cJSON_GetArrayItem(p_PTZActionParamList, m);
				cJSON* p_action_type = cJSON_GetObjectItemEx(item_ptz_action, "ActionType", cJSON_Number);
				if (NULL != p_action_type)
				{
					p_src->mot_alarm_list[i].ptz_action_param_list[m].action_type = p_action_type->valueint;
				}
				cJSON* p_action_id = cJSON_GetObjectItemEx(item_ptz_action, "ActionID", cJSON_Number);
				if (NULL != p_action_id)
				{
					p_src->mot_alarm_list[i].ptz_action_param_list[m].action_id = p_action_id->valueint;
				}
				cJSON* p_action_name = cJSON_GetObjectItemEx(item_ptz_action, "ActionName", cJSON_String);
				if (NULL != p_action_name)
				{
					strcpy(p_src->mot_alarm_list[i].ptz_action_param_list[m].action_name, p_action_name->valuestring);
				}
				cJSON* p_ptz_action_type = cJSON_GetObjectItemEx(item_ptz_action, "PTZActionType", cJSON_Number);
				if (NULL != p_ptz_action_type)
				{
					p_src->mot_alarm_list[i].ptz_action_param_list[m].ptz_action_type = p_ptz_action_type->valueint;
				}
				cJSON* p_ptz_action_id = cJSON_GetObjectItemEx(item_ptz_action, "PTZActionID", cJSON_Number);
				if (NULL != p_ptz_action_id)
				{
					p_src->mot_alarm_list[i].ptz_action_param_list[m].ptz_action_id = p_ptz_action_id->valueint;
				}
				cJSON* p_ptz_chn_id = cJSON_GetObjectItemEx(item_ptz_action, "PTZChannelID", cJSON_Number);
				if (NULL != p_ptz_chn_id)
				{
					p_src->mot_alarm_list[i].ptz_action_param_list[m].ptz_chn_id = p_ptz_chn_id->valueint;
				}
			}
		}

		cJSON *p_AlarmOutActionList = cJSON_GetObjectItemEx(item, "AlarmOutActionList", cJSON_Array);
		if (NULL != p_AlarmOutActionList)
		{
			int arraysize_alarm_out = cJSON_GetArraySize(p_AlarmOutActionList);
			p_src->mot_alarm_list[i].alarm_out_size = arraysize_alarm_out;
			for (int n = 0; n < arraysize_alarm_out; n++)
			{
				cJSON *item_alarm_out = cJSON_GetArrayItem(p_AlarmOutActionList, n);
				cJSON* p_action_type = cJSON_GetObjectItemEx(item_alarm_out, "ActionType", cJSON_Number);
				if (NULL != p_action_type)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].action_type = p_action_type->valueint;
				}
				cJSON* p_action_id = cJSON_GetObjectItemEx(item_alarm_out, "ActionID", cJSON_Number);
				if (NULL != p_action_id)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].action_id = p_action_id->valueint;
				}
				cJSON* p_action_name = cJSON_GetObjectItemEx(item_alarm_out, "ActionName", cJSON_String);
				if (NULL != p_action_name)
				{
					strcpy(p_src->mot_alarm_list[i].alarm_out_list[n].action_name, p_action_name->valuestring);
				}
				cJSON* p_device_id = cJSON_GetObjectItemEx(item_alarm_out, "DeviceId", cJSON_String);
				if (NULL != p_device_id)
				{
					strcpy(p_src->mot_alarm_list[i].alarm_out_list[n].device_id, p_device_id->valuestring);
				}
				cJSON* p_alarm_out_id = cJSON_GetObjectItemEx(item_alarm_out, "AlarmOutId", cJSON_Number);
				if (NULL != p_alarm_out_id)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].alarm_out_id = p_alarm_out_id->valueint;
				}
				cJSON* p_alarm_out_flag = cJSON_GetObjectItemEx(item_alarm_out, "AlarmOutFlag", cJSON_Number);
				if (NULL != p_alarm_out_flag)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].alarm_out_flag = p_alarm_out_flag->valueint;
				}
				cJSON* p_event_type_id = cJSON_GetObjectItemEx(item_alarm_out, "EventTypeId", cJSON_Number);
				if (NULL != p_event_type_id)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].event_type_id = p_event_type_id->valueint;
				}
				cJSON* p_alarm_time = cJSON_GetObjectItemEx(item_alarm_out, "AlarmTime", cJSON_Number);
				if (NULL != p_alarm_time)
				{
					p_src->mot_alarm_list[i].alarm_out_list[n].alarm_time = p_alarm_time->valueint;
				}
			}
		}

		cJSON *p_RecordActionParamList = cJSON_GetObjectItemEx(item, "RecordActionParamList", cJSON_Array);
		if (NULL != p_RecordActionParamList)
		{
			int arraysize_record_action = cJSON_GetArraySize(p_RecordActionParamList);
			p_src->mot_alarm_list[i].record_param_size = arraysize_record_action;
			for (size_t x = 0; x < arraysize_record_action; x++)
			{
				cJSON *item_record_action = cJSON_GetArrayItem(p_RecordActionParamList, x);
				cJSON* p_action_type = cJSON_GetObjectItemEx(item_record_action, "ActionType", cJSON_Number);
				if (NULL != p_action_type)
				{
					p_src->mot_alarm_list[i].record_param_list[x].action_type = p_action_type->valueint;
				}
				cJSON* p_action_id = cJSON_GetObjectItemEx(item_record_action, "ActionID", cJSON_Number);
				if (NULL != p_action_id)
				{
					p_src->mot_alarm_list[i].record_param_list[x].action_id = p_action_id->valueint;
				}
				cJSON* p_action_name = cJSON_GetObjectItemEx(item_record_action, "ActionName", cJSON_String);
				if (NULL != p_action_name)
				{
					strcpy(p_src->mot_alarm_list[i].record_param_list[x].action_name, p_action_name->valuestring);
				}
				cJSON* p_pre_record_flag = cJSON_GetObjectItemEx(item_record_action, "PreRecordFlag", cJSON_Number);
				if (NULL != p_pre_record_flag)
				{
					p_src->mot_alarm_list[i].record_param_list[x].pre_record_flag = p_pre_record_flag->valueint;
				}
				cJSON* p_delay_record_time = cJSON_GetObjectItemEx(item_record_action, "DelayRecordTime", cJSON_Number);
				if (NULL != p_delay_record_time)
				{
					p_src->mot_alarm_list[i].record_param_list[x].delay_record_time = p_delay_record_time->valueint;
				}
			}
		}
	}
	return 0;
}

int json_parser_alarm_info_list(char *param, jy_dev_all_alarm_list_t *p_src, int n_times)
{
	int main_type = 0;
	int sub_type = 0;
	cJSON* p_json_root = cJSON_Parse(param);
	if (p_json_root == NULL)
	{
		return PARAM_ERROR;
	}

	cJSON* p_json_is_more = cJSON_GetObjectItemEx(p_json_root, "is_more", cJSON_True);
	if (p_json_is_more == NULL)
	{
		p_json_is_more = cJSON_GetObjectItemEx(p_json_root, "is_more", cJSON_False);
		if (NULL != p_json_is_more)
		{
			p_src->is_more = p_json_is_more->valueint;
		}
	}
	else
	{
		p_src->is_more = p_json_is_more->valueint;
	}

	cJSON *p_data = cJSON_GetObjectItemEx(p_json_root, "data", cJSON_Array);
	if (p_data == NULL)
	{
		return JSON_NODE_ERROR;
	}
	int data_size = cJSON_GetArraySize(p_data);
	int i = 0;
	int info_num = 0;
	if (0 == n_times)
		i = 0;
	else
		i = 1;
		
	for (; i < data_size; ++i)
	{
		info_num = (n_times * 59 + i);
		cJSON *p_json_data = cJSON_GetArrayItem(p_data, i);
		if (NULL == p_json_data)
		{
			return JSON_ARRAY_ERROR;
		}
		cJSON* p_json_src_id = cJSON_GetObjectItemEx(p_json_data, "src_id", cJSON_Number);
		if (NULL != p_json_src_id)
		{
			p_src->alarm_info_list[info_num].src_id = p_json_src_id->valueint;
		}
		cJSON* p_json_main_type = cJSON_GetObjectItemEx(p_json_data, "main_type", cJSON_Number);
		if (NULL != p_json_main_type)
		{
			main_type = p_json_main_type->valueint;
		}
		cJSON* p_json_sub_type = cJSON_GetObjectItemEx(p_json_data, "sub_type", cJSON_Number);
		if (NULL != p_json_sub_type)
		{
			sub_type = p_json_sub_type->valueint;
		}
		if (1 == main_type)
		{
			if (1 == sub_type)
			{
				p_src->alarm_info_list[info_num].alarm_type = IO_ALARM_TYPE;
			}
			else if (2 == sub_type)
			{
				p_src->alarm_info_list[info_num].alarm_type = MOTION_ALARM_TYPE;
			}
			else
			{
				p_src->alarm_info_list[info_num].alarm_type = ALL_ALARM_TYPE;
			}
		}
		else if (4 == main_type)
		{
			p_src->alarm_info_list[info_num].alarm_type = DISK_ALARM_TYPE;
		}
		else
		{
			p_src->alarm_info_list[info_num].alarm_type = ALL_ALARM_TYPE;
		}
		cJSON* p_json_time = cJSON_GetObjectItemEx(p_json_data, "time", cJSON_String);
		if (NULL != p_json_time)
		{
			strcpy(p_src->alarm_info_list[info_num].alarm_time, p_json_time->valuestring);
		}
		++p_src->num;
	}
	cJSON_Delete(p_json_root);
	return 0;
}

int json_perser_record_policy(char *param, jy_dev_record_policy_list_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		cJSON_Delete(p_root);
		return PARAM_ERROR;
	}

	cJSON* p_record_policy_list = cJSON_GetObjectItemEx(p_root, "record_policy_list", cJSON_Array);
	if (NULL == p_record_policy_list)
	{
		cJSON_Delete(p_root);
		return JSON_NODE_ERROR;
	}

	int arraysize = cJSON_GetArraySize(p_record_policy_list);
	p_src->num = arraysize;
	for (int i = 0; i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_record_policy_list, i);
		if (NULL != item)
		{
			cJSON* p_record_open_flag = cJSON_GetObjectItemEx(item, "record_open_flag", cJSON_Number);
			if (NULL != p_record_open_flag)
			{
				p_src->record_policy_list[i].record_open_flag = p_record_open_flag->valueint;
			}
			cJSON* p_record_mode = cJSON_GetObjectItemEx(item, "record_mode", cJSON_Number);
			if (NULL != p_record_mode)
			{
				p_src->record_policy_list[i].record_mode = p_record_mode->valueint;
			}
			cJSON* p_dev_id = cJSON_GetObjectItemEx(item, "dev_id", cJSON_String);
			if (NULL != p_dev_id)
			{
				strcpy(p_src->record_policy_list[i].dev_id, p_dev_id->valuestring);
			}
			cJSON* p_channel_id = cJSON_GetObjectItemEx(item, "channel_id", cJSON_Number);
			if (NULL != p_channel_id)
			{
				p_src->record_policy_list[i].channel_id = p_channel_id->valueint;
			}
			cJSON* p_stream_id = cJSON_GetObjectItemEx(item, "stream_id", cJSON_Number);
			if (NULL != p_stream_id)
			{
				p_src->record_policy_list[i].stream_id = p_stream_id->valueint;
			}
			cJSON* p_save_days = cJSON_GetObjectItemEx(item, "save_days", cJSON_Number);
			if (NULL != p_save_days)
			{
				p_src->record_policy_list[i].save_days = p_save_days->valueint;
			}
			cJSON* p_audio_open_flag = cJSON_GetObjectItemEx(item, "audio_open_flag", cJSON_Number);
			if (NULL != p_audio_open_flag)
			{
				p_src->record_policy_list[i].audio_open_flag = p_audio_open_flag->valueint;
			}
			cJSON* p_disk_id = cJSON_GetObjectItemEx(item, "disk_id", cJSON_Number);
			if (NULL != p_disk_id)
			{
				p_src->record_policy_list[i].disk_id = p_disk_id->valueint;
			}

			cJSON* p_time_list = cJSON_GetObjectItemEx(item, "schedule_time_list", cJSON_Array);
			if (NULL != p_time_list)
			{
				int arraysize_time = cJSON_GetArraySize(p_time_list);
				p_src->record_policy_list[i].schedule_time_size = arraysize_time;
				for (int j = 0; j < arraysize_time; j++)
				{
					cJSON *item_time = cJSON_GetArrayItem(p_time_list, j);
					cJSON* p_week_day = cJSON_GetObjectItemEx(item_time, "weekday", cJSON_Number);
					if (NULL != p_week_day)
					{
						p_src->record_policy_list[i].schedule_time_list[j].week_day = p_week_day->valueint;
					}
					cJSON* p_start_time = cJSON_GetObjectItemEx(item_time, "start_time", cJSON_Number);
					if (NULL != p_start_time)
					{
						p_src->record_policy_list[i].schedule_time_list[j].start_time = p_start_time->valueint;
					}
					cJSON* p_end_time = cJSON_GetObjectItemEx(item_time, "end_time", cJSON_Number);
					if (NULL != p_end_time)
					{
						p_src->record_policy_list[i].schedule_time_list[j].end_time = p_end_time->valueint;
					}
				}
			}

			cJSON *p_snap_shot_para = cJSON_GetObjectItemEx(item, "snap_shot_para", cJSON_Object);
			if (NULL != p_snap_shot_para)
			{
				cJSON* p_duration = cJSON_GetObjectItemEx(p_snap_shot_para, "duration", cJSON_Number);
				if (NULL != p_duration)
				{
					p_src->record_policy_list[i].snap_shot_para.duration = p_duration->valueint;
				}
				cJSON* p_quality = cJSON_GetObjectItemEx(p_snap_shot_para, "quality", cJSON_Number);
				if (NULL != p_quality)
				{
					p_src->record_policy_list[i].snap_shot_para.quality = p_quality->valueint;
				}
				cJSON* p_interval = cJSON_GetObjectItemEx(p_snap_shot_para, "interval", cJSON_Number);
				if (NULL != p_interval)
				{
					p_src->record_policy_list[i].snap_shot_para.interval = p_interval->valueint;
				}
				cJSON* p_shoot_times = cJSON_GetObjectItemEx(p_snap_shot_para, "shoot_times", cJSON_Number);
				if (NULL != p_shoot_times)
				{
					p_src->record_policy_list[i].snap_shot_para.shoot_times = p_shoot_times->valueint;
				}
				cJSON *p_video_solution= cJSON_GetObjectItemEx(p_snap_shot_para, "video_solution", cJSON_Object);
				if (NULL != p_video_solution)
				{
					cJSON* p_video_height = cJSON_GetObjectItemEx(p_video_solution, "video_height", cJSON_Number);
					if (NULL != p_video_height)
					{
						p_src->record_policy_list[i].snap_shot_para.video_solution.video_height = p_video_height->valueint;
					}
					cJSON* p_video_width = cJSON_GetObjectItemEx(p_video_solution, "video_width", cJSON_Number);
					if (NULL != p_video_width)
					{
						p_src->record_policy_list[i].snap_shot_para.video_solution.video_width = p_video_width->valueint;
					}
					cJSON* p_resolution_name = cJSON_GetObjectItemEx(item, "resolution_name", cJSON_String);
					if (NULL != p_resolution_name)
					{
						strcpy(p_src->record_policy_list[i].snap_shot_para.video_solution.resolution_name, p_resolution_name->valuestring);
					}
				}
			}
		}
	}
	return 0;
}

int json_perser_record_directory(char *param, jy_dev_record_directory_list_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		cJSON_Delete(p_root);
		return PARAM_ERROR;
	}

	cJSON* p_disk_report_list = cJSON_GetObjectItemEx(p_root, "disk_report_list", cJSON_Array);
	if (NULL == p_disk_report_list)
	{
		cJSON_Delete(p_root);
		return JSON_NODE_ERROR;
	}

	int arraysize = cJSON_GetArraySize(p_disk_report_list);
	p_src->num = arraysize;
	for (int i = 0; i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_disk_report_list, i);
		if (NULL != item)
		{
			cJSON* p_disk_id = cJSON_GetObjectItemEx(item, "disk_id", cJSON_Number);
			if (NULL != p_disk_id)
			{
				p_src->record_directory_list[i].disk_id = p_disk_id->valueint;
			}
			cJSON* p_disk_type = cJSON_GetObjectItemEx(item, "disk_type", cJSON_Number);
			if (NULL != p_disk_type)
			{
				p_src->record_directory_list[i].disk_type = p_disk_type->valueint;
			}
			cJSON* p_disk_state = cJSON_GetObjectItemEx(item, "disk_state", cJSON_Number);
			if (NULL != p_disk_state)
			{
				p_src->record_directory_list[i].disk_state = p_disk_state->valueint;
			}
			cJSON* p_disk_space = cJSON_GetObjectItemEx(item, "disk_space", cJSON_Number);
			if (NULL != p_disk_space)
			{
				p_src->record_directory_list[i].disk_space = p_disk_space->valueint;
			}
			cJSON* p_disk_free_space = cJSON_GetObjectItemEx(item, "disk_free_space", cJSON_Number);
			if (NULL != p_disk_free_space)
			{
				p_src->record_directory_list[i].disk_free_space = p_disk_free_space->valueint;
			}
			cJSON* p_record_flag = cJSON_GetObjectItemEx(item, "record_flag", cJSON_Number);
			if (NULL != p_record_flag)
			{
				p_src->record_directory_list[i].record_flag = p_record_flag->valueint;
			}
			cJSON* p_use_days = cJSON_GetObjectItemEx(item, "use_days", cJSON_Number);
			if (NULL != p_use_days)
			{
				p_src->record_directory_list[i].use_days = p_use_days->valueint;
			}
			cJSON* p_record_bitrate = cJSON_GetObjectItemEx(item, "record_bitrate", cJSON_Number);
			if (NULL != p_record_bitrate)
			{
				p_src->record_directory_list[i].record_bitrate = p_record_bitrate->valueint;
			}
			cJSON* p_record_free_space = cJSON_GetObjectItemEx(item, "record_free_space", cJSON_Number);
			if (NULL != p_record_free_space)
			{
				p_src->record_directory_list[i].record_free_space = p_record_free_space->valueint;
			}
			cJSON* p_snapshot_flag = cJSON_GetObjectItemEx(item, "snapshot_flag", cJSON_Number);
			if (NULL != p_snapshot_flag)
			{
				p_src->record_directory_list[i].snapshot_flag = p_snapshot_flag->valueint;
			}
			cJSON* p_snapshot_bitrate = cJSON_GetObjectItemEx(item, "snapshot_bitrate", cJSON_Number);
			if (NULL != p_snapshot_bitrate)
			{
				p_src->record_directory_list[i].snapshot_bitrate = p_snapshot_bitrate->valueint;
			}
			cJSON* p_snapshot_free_space = cJSON_GetObjectItemEx(item, "snapshot_free_space", cJSON_Number);
			if (NULL != p_snapshot_free_space)
			{
				p_src->record_directory_list[i].snapshot_free_space = p_snapshot_free_space->valueint;
			}
		}
	}
	return 0;
}

int json_parser_pb_rec_list(char *param, jy_dev_pb_rec_list_t *p_src)
{
	cJSON* p_root = cJSON_Parse(param);
	if (p_root == NULL)
	{
		cJSON_Delete(p_root);
		return PARAM_ERROR;
	}

	cJSON* p_pb_data_list = cJSON_GetObjectItemEx(p_root, "data", cJSON_Array);
	if (NULL == p_pb_data_list)
	{
		cJSON_Delete(p_root);
		return JSON_NODE_ERROR;
	}
	int arraysize = cJSON_GetArraySize(p_pb_data_list);
	p_src->num = arraysize;
	for (int i = 0; i < arraysize; i++)
	{
		cJSON *item = cJSON_GetArrayItem(p_pb_data_list, i);
		if (NULL != item)
		{
			cJSON* p_start_time = cJSON_GetObjectItemEx(item, "s_time", cJSON_String);
			if (NULL != p_start_time)
			{
				strcpy(p_src->pb_rec_list[i].start_time, p_start_time->valuestring);
			}
			cJSON* p_end_time = cJSON_GetObjectItemEx(item, "e_time", cJSON_String);
			if (NULL != p_end_time)
			{
				strcpy(p_src->pb_rec_list[i].end_time, p_end_time->valuestring);
			}
		}
	}
	return 0;
}